/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.trimou.annotations.Internal;
import org.trimou.util.Checker;

@Internal
public final class Strings {
    public static final String EMPTY = "";
    public static final String GAP = " ";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String LINE_SEPARATOR_LF = "\n";
    public static final String LINE_SEPARATOR_CRLF = "\r\n";
    public static final String LINE_SEPARATOR_CR = "\r";
    public static final String SLASH = "/";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String DOT = ".";
    public static final String UNDERSCORE = "_";
    public static final String EQUALS = "=";
    public static final String NOT_AVAILABLE = "N/A";
    public static final String URL_PROCOTOL_FILE = "file";
    public static final String URI_PROCOTOL_JAR = "jar";
    public static final String THIS = "this";

    public static boolean isStringLiteralSeparator(char character) {
        return character == '\"' || character == '\'';
    }

    public static boolean isEmpty(CharSequence sequence) {
        return sequence == null || sequence.length() == 0;
    }

    public static String uncapitalize(String word) {
        if (Strings.isEmpty(word)) {
            return word;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(Character.toLowerCase(word.charAt(0)));
        if (word.length() > 1) {
            builder.append(word.substring(1, word.length()));
        }
        return builder.toString();
    }

    public static String capitalizeFully(String text, Character delimiter) {
        if (Strings.isEmpty(text)) {
            return text;
        }
        text = text.toLowerCase();
        boolean capitalizeNext = true;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (delimiter.equals(Character.valueOf(ch))) {
                capitalizeNext = true;
                builder.append(ch);
                continue;
            }
            if (capitalizeNext) {
                builder.append(Character.toTitleCase(ch));
                capitalizeNext = false;
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    public static String replace(String text, String search, String replacement) {
        if (Strings.isEmpty(text) || Strings.isEmpty(search) || replacement == null) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(search, start);
        if (end == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        while (end != -1) {
            builder.append(text.substring(start, end));
            builder.append(replacement);
            start = end + search.length();
            end = text.indexOf(search, start);
        }
        builder.append(text.substring(start));
        return builder.toString();
    }

    public static String removeSuffix(String text, String suffix) {
        if (Strings.isEmpty(text) || Strings.isEmpty(suffix)) {
            return text;
        }
        if (text.endsWith(suffix)) {
            return text.substring(0, text.length() - suffix.length());
        }
        return text;
    }

    public static List<String> split(String text, String delimiter) {
        if (Strings.isEmpty(text) || Strings.isEmpty(delimiter)) {
            return Collections.singletonList(text);
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, delimiter);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return Collections.unmodifiableList(tokens);
    }

    public static boolean containsWhitespace(String text) {
        if (Strings.isEmpty(text)) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOnlyWhitespace(String text) {
        if (Strings.isEmpty(text)) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOnlyDigits(String text) {
        if (Strings.isEmpty(text)) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String repeat(String text, int times, String separator) {
        if (Strings.isEmpty(text) || times < 0) {
            return text;
        }
        if (times == 0) {
            return EMPTY;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            builder.append(text);
            if (i + 1 >= times) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static String substringAfter(String text, String delimiter) {
        Checker.checkArgumentsNotNull(text, delimiter);
        int index = text.indexOf(delimiter);
        if (index == -1) {
            return EMPTY;
        }
        return text.substring(index + delimiter.length());
    }

    public static boolean isListLiteralStart(char character) {
        return character == '[';
    }

    public static boolean isListLiteralEnd(char character) {
        return character == ']';
    }

    public static boolean isListLiteral(String value) {
        return Strings.isListLiteralStart(value.charAt(0)) && Strings.isListLiteralEnd(value.charAt(value.length() - 1));
    }
}

