/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.interpolation.MissingValueHandler;
import org.trimou.engine.interpolation.ThrowingExceptionMissingValueHandler;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.lambda.InputProcessingLambda;
import org.trimou.lambda.SpecCompliantLambda;
import org.trimou.util.ImmutableMap;

public class ValueSegmentTest
extends AbstractEngineTest {
    @Override
    @Before
    public void buildEngine() {
    }

    @Test
    public void testNoValueProblem() {
        try {
            MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.NO_VALUE_INDICATES_PROBLEM, (Object)true).build().compileMustache("value_segment_problem", "{{foo}}").render(null);
        }
        catch (MustacheException e) {
            if (!e.getCode().equals(MustacheProblem.RENDER_NO_VALUE)) {
                Assert.fail((String)"Invalid problem");
            }
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testLambda() {
        InputProcessingLambda lambda = new InputProcessingLambda(){

            public String invoke(String text) {
                Assert.assertNull((Object)text);
                return "ok";
            }

            public boolean isReturnValueInterpolated() {
                return true;
            }
        };
        Assert.assertEquals((Object)"ok", (Object)MustacheEngineBuilder.newBuilder().build().compileMustache("value_segment_lambda", "{{lambda}}").render((Object)ImmutableMap.of((Object)"lambda", (Object)lambda)));
    }

    @Test
    public void testValueEscaping() {
        String shouldBeEscaped = "<&>";
        Assert.assertEquals((Object)"&lt;&amp;&gt;", (Object)MustacheEngineBuilder.newBuilder().build().compileMustache("value_escaping", "{{foo}}").render((Object)ImmutableMap.of((Object)"foo", (Object)shouldBeEscaped)));
        Assert.assertEquals((Object)shouldBeEscaped, (Object)MustacheEngineBuilder.newBuilder().setProperty((ConfigurationKey)EngineConfigurationKey.SKIP_VALUE_ESCAPING, (Object)true).build().compileMustache("skip_value_escaping", "{{foo}}").render((Object)ImmutableMap.of((Object)"foo", (Object)shouldBeEscaped)));
    }

    @Test
    public void testMissingValueHandlerUsedForLambda() {
        block2: {
            SpecCompliantLambda lambda = new SpecCompliantLambda(){

                public String invoke(String text) {
                    return null;
                }
            };
            try {
                MustacheEngineBuilder.newBuilder().setMissingValueHandler((MissingValueHandler)new ThrowingExceptionMissingValueHandler()).build().compileMustache("value_lambda_missing_value_handler", "{{this}}").render((Object)lambda);
                Assert.fail();
            }
            catch (MustacheException e) {
                if (MustacheProblem.RENDER_NO_VALUE.equals((Object)e.getCode())) break block2;
                Assert.fail((String)"Unexpected problem");
            }
        }
    }
}

