/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.Hammer;
import org.trimou.util.ImmutableList;

public class EachHelperTest
extends AbstractEngineTest {
    @Test
    public void testSkipIfNull() {
        Assert.assertEquals((Object)"foobaz", (Object)this.engine.compileMustache("each_skipifnull", "{{#each this apply='skipIfNull'}}{{this}}{{/each}}").render((Object)ImmutableList.of((Object[])new String[]{"foo", null, "baz"})));
    }

    @Test
    public void testSkipUnless() {
        Assert.assertEquals((Object)"true", (Object)this.engine.compileMustache("each_skipunless_1", "{{#each this apply='skipUnless:booleanValue'}}{{this}}{{/each}}").render((Object)ImmutableList.of((Object[])new Serializable[]{"foo", null, Boolean.FALSE, Boolean.TRUE})));
        Assert.assertEquals((Object)"=", (Object)this.engine.compileMustache("each_skipunless_2", "={{#each this apply='skipUnless:map.isEmpty'}}{{this}}{{/each}}").render((Object)ImmutableList.of((Object[])new Hammer[]{new Hammer()})));
    }

    @Test
    public void testSkipIf() {
        Assert.assertEquals((Object)"foofalse", (Object)this.engine.compileMustache("each_skipif_1", "{{#each this apply='skipIf:isCool'}}{{this}}{{/each}}").render((Object)ImmutableList.of((Object[])new Object[]{"foo", new Hammer(), Boolean.FALSE})));
        Assert.assertEquals((Object)"=10", (Object)this.engine.compileMustache("each_skipif_2", "={{#each this apply='skipIf:map.isEmpty'}}{{age}}{{/each}}").render((Object)ImmutableList.of((Object[])new Hammer[]{new Hammer()})));
        Assert.assertEquals((Object)"11", (Object)this.engine.compileMustache("each_skipif_3", "{{#each this apply='skipIf:empty'}}{{length}}{{/each}}").render((Object)ImmutableList.of((Object[])new String[]{null, "", "1", "2"})));
    }

    @Test
    public void testMap() {
        Assert.assertEquals((Object)"332", (Object)this.engine.compileMustache("each_map_1", "{{#each this apply='map:length'}}{{this}}{{/each}}").render((Object)ImmutableList.of((Object[])new String[]{"foo", "bar", "uf"})));
        Assert.assertEquals((Object)"1020", (Object)this.engine.compileMustache("each_map_2", "{{#each this apply='map:age.longValue'}}{{this}}{{/each}}").render((Object)ImmutableList.of((Object[])new Hammer[]{new Hammer(), new Hammer(20)})));
    }

    @Test
    public void testIterateOverPeek() {
        Assert.assertEquals((Object)"123", (Object)this.engine.compileMustache("each_peek_1", "{{#with this}}{{#each}}{{this}}{{/each}}{{/with}}").render((Object)ImmutableList.of((Object[])new String[]{"1", "2", "3"})));
    }
}

