/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.interpolation.BracketDotKeySplitter;
import org.trimou.engine.interpolation.KeySplitter;
import org.trimou.engine.interpolation.MissingValueHandler;
import org.trimou.handlebars.EvalHelper;
import org.trimou.handlebars.HelpersBuilder;
import org.trimou.util.ImmutableList;
import org.trimou.util.ImmutableMap;

public class EvalHelperTest
extends AbstractTest {
    @Test
    public void testHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addEval().build()).build();
        String[] array = new String[]{"alpha", "bravo", "charlie"};
        List list = ImmutableList.of((Object[])new String[]{"foo", "bar", "baz"});
        Map data = ImmutableMap.of((Object)"array", (Object)array, (Object)"list", (Object)list);
        Assert.assertEquals((Object)"foo:alpha,bar:bravo,baz:charlie", (Object)engine.compileMustache("eval_helper1", "{{#each list}}{{this}}:{{eval 'array' iter.position}}{{#if iter.hasNext}},{{/if}}{{/each}}").render((Object)data));
    }

    @Test
    public void testCustomNotation() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().setKeySplitter((KeySplitter)new BracketDotKeySplitter()).registerHelpers(HelpersBuilder.empty().addEval((EvalHelper.Notation)new EvalHelper.BracketDotNotation()).build()).build();
        Assert.assertEquals((Object)"val", (Object)engine.compileMustache("eval_helper_notation", "{{eval 'this' this.keySet.iterator.next}}").render((Object)ImmutableMap.of((Object)"my.key", (Object)"val")));
    }

    @Test
    public void testNullValue() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().setMissingValueHandler(new MissingValueHandler(){

            public void init(Configuration configuration) {
            }

            public Set<ConfigurationKey> getConfigurationKeys() {
                return Collections.emptySet();
            }

            public Object handle(MustacheTagInfo tagInfo) {
                return "Hello";
            }
        }).registerHelpers(HelpersBuilder.empty().addEval().build()).build();
        Assert.assertEquals((Object)"Hello", (Object)engine.compileMustache("eval_null_val1", "{{eval 'foo' 'bar'}}").render(null));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("eval_null_val2", "{{#eval 'foo' 'bar'}}{{this}}{{/eval}}").render(null));
    }
}

