/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.config;

import java.util.Map;
import org.trimou.engine.config.ConfigurationExtension;
import org.trimou.handlebars.Helper;
import org.trimou.util.Checker;

public class ConfigurationExtensions {
    private ConfigurationExtensions() {
    }

    public static void registerHelpers(ConfigurationExtension.ConfigurationExtensionBuilder builder, Map<String, Helper> helpers) {
        Checker.checkArgumentsNotNull(builder, helpers);
        for (Map.Entry<String, Helper> entry : helpers.entrySet()) {
            ConfigurationExtensions.registerHelper(builder, entry.getKey(), entry.getValue());
        }
    }

    public static void registerHelper(ConfigurationExtension.ConfigurationExtensionBuilder builder, String name, Helper helper) {
        Checker.checkArgumentsNotNull(builder, name, helper);
        try {
            builder.registerHelper(name, helper);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

