/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import org.trimou.handlebars.BasicHelper;
import org.trimou.handlebars.Options;

public class EvalHelper
extends BasicHelper {
    private final Notation notation;

    public EvalHelper() {
        this(new DotNotation());
    }

    public EvalHelper(Notation notation) {
        this.notation = notation;
    }

    @Override
    public void execute(Options options) {
        StringBuilder key = new StringBuilder();
        for (Object o : options.getParameters()) {
            this.notation.append(key, o.toString());
        }
        Object value = options.getValue(key.toString());
        if (this.isSection(options)) {
            if (value != null) {
                options.push(value);
                options.fn();
                options.pop();
            }
        } else {
            if (value == null) {
                value = this.configuration.getMissingValueHandler().handle(options.getTagInfo());
            }
            if (value != null) {
                this.convertAndAppend(options, value);
            }
        }
    }

    public static class BracketDotNotation
    implements Notation {
        @Override
        public void append(StringBuilder builder, String part) {
            if (builder.length() > 0) {
                builder.append("[\"");
                builder.append(part);
                builder.append("\"]");
            } else {
                builder.append(part);
            }
        }
    }

    public static class DotNotation
    implements Notation {
        @Override
        public void append(StringBuilder builder, String part) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(part);
        }
    }

    public static interface Notation {
        public void append(StringBuilder var1, String var2);
    }
}

