/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.ExceptionAssert;
import org.trimou.Hammer;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.MustacheTagType;
import org.trimou.engine.locator.MapTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.resolver.AbstractResolver;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.Resolver;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.AbstractHelper;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.Options;
import org.trimou.util.ImmutableMap;

public class OptionsTest
extends AbstractTest {
    @Test
    public void testParameters() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("test", (Helper)new AbstractHelper(){

            public void execute(Options options) {
                List params = options.getParameters();
                Assert.assertEquals((long)3L, (long)params.size());
                Assert.assertEquals((Object)"1", params.get(0));
                Assert.assertEquals((Object)10, params.get(1));
                Assert.assertNull(params.get(2));
                Assert.assertEquals((Object)"1", (Object)options.getParameter(0, null));
                Assert.assertEquals((Object)10, (Object)options.getParameter(1, null));
                Assert.assertNull((Object)options.getParameter(4, null));
                Assert.assertNull((Object)options.getParameter(-5, null));
            }
        }).build();
        engine.compileMustache("helper_params", "{{test \"1\" this.age nonexisting}}").render((Object)new Hammer());
    }

    @Test
    public void testHash() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("test", (Helper)new AbstractHelper(){

            public void execute(Options options) {
                Map hash = options.getHash();
                Assert.assertEquals((long)3L, (long)hash.size());
                Assert.assertEquals((Object)"1", hash.get("first"));
                Assert.assertEquals((Object)10, hash.get("second"));
                Assert.assertNull(hash.get("third"));
                ExceptionAssert.expect(UnsupportedOperationException.class).check(() -> hash.remove("first"));
            }
        }).build();
        engine.compileMustache("helper_params", "{{test first=\"1\" second=this.age third=nonexisting}}").render((Object)new Hammer());
    }

    @Test
    public void testPush() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("test", (Helper)new AbstractHelper(){

            public void execute(Options options) {
                options.push((Object)"OK");
                options.fn();
            }
        }).build();
        Assert.assertEquals((Object)"OK|HAMMER", (Object)engine.compileMustache("helper_params", "{{#test}}{{this}}{{/test}}|{{this}}").render((Object)new Hammer()));
    }

    @Test
    public void testPop() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("test", (Helper)new AbstractHelper(){

            public void execute(Options options) {
                options.pop();
            }
        }).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_HELPER_INVALID_POP_OPERATION).check(() -> engine.compileMustache("helper_params", "{{test}}").render((Object)new Hammer()));
    }

    @Test
    public void testPartial() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)new MapTemplateLocator(ImmutableMap.of((Object)"foo", (Object)"{{this}}"))).registerHelper("test", (Helper)new AbstractHelper(){

            public void execute(Options options) {
                options.partial(options.getParameters().get(0).toString());
            }
        }).build();
        Assert.assertEquals((Object)"HELLO", (Object)engine.compileMustache("helper_partial01", "{{test 'foo'}}").render((Object)"HELLO"));
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_INVALID_PARTIAL_KEY).check(() -> engine.compileMustache("helper_partial02", "{{test 'bar'}}").render((Object)"HELLO"));
    }

    @Test
    public void testPeek() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("test", (Helper)new AbstractHelper(){

            public void execute(Options options) {
                options.append((CharSequence)options.peek().toString());
            }
        }).build();
        Assert.assertEquals((Object)"HELLO", (Object)engine.compileMustache("helper_peek", "{{test}}").render((Object)"HELLO"));
    }

    @Test
    public void testGetAppendable() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("test", (Helper)new AbstractHelper(){

            public void execute(Options options) {
                try {
                    options.getAppendable().append(options.peek().toString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }).build();
        Assert.assertEquals((Object)"HELLO", (Object)engine.compileMustache("helper_getappendable", "{{test}}").render((Object)"HELLO"));
    }

    @Test
    public void testGetContentLiteralBlock() {
        final StringBuilder builder = new StringBuilder();
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("test", (Helper)new AbstractHelper(){

            public void execute(Options options) {
                builder.append(options.getContentLiteralBlock());
            }
        }).build();
        String literal = "This is /n a {{foo bar='ok'}}{{#each this}}{{.}}{{/each}}/n/n {{join 'foo' 'bar' delimiter=' : '}}";
        engine.compileMustache("helper_getcontentliteralblock", "{{#test}}" + literal + "{{/test}}").render(null);
        Assert.assertEquals((Object)literal, (Object)builder.toString());
    }

    @Test
    public void testGetTagInfo() {
        final AtomicReference reference = new AtomicReference();
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("test", (Helper)new AbstractHelper(){

            public void execute(Options options) {
                reference.set(options.getTagInfo());
            }
        }).build();
        engine.compileMustache("helper_gettaginfo", "{{#test}}This is {{foo}} and {{^bar}}{{/bar}}{{/test}}").render(null);
        Assert.assertEquals((Object)MustacheTagType.SECTION, (Object)((MustacheTagInfo)reference.get()).getType());
        Assert.assertEquals((Object)"test", (Object)((MustacheTagInfo)reference.get()).getText());
        List children = ((MustacheTagInfo)reference.get()).getChildTags();
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((Object)MustacheTagType.VARIABLE, (Object)((MustacheTagInfo)((MustacheTagInfo)reference.get()).getChildTags().get(0)).getType());
        Assert.assertEquals((Object)MustacheTagType.INVERTED_SECTION, (Object)((MustacheTagInfo)((MustacheTagInfo)reference.get()).getChildTags().get(1)).getType());
    }

    @Test
    public void testFnAppendable() {
        final StringBuilder builder = new StringBuilder();
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("test", (Helper)new AbstractHelper(){

            public void execute(Options options) {
                options.fn((Appendable)builder);
            }
        }).build();
        String literal = "This is /n a foo";
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("helper_fnappendable", "{{#test}}" + literal + "{{/test}}").render(null));
        Assert.assertEquals((Object)literal, (Object)builder.toString());
    }

    @Test
    public void testGetValue() {
        final AtomicBoolean released = new AtomicBoolean(false);
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)new AbstractResolver(1){

            public Object resolve(Object contextObject, String name, ResolutionContext context) {
                context.registerReleaseCallback(() -> released.set(true));
                return "foo";
            }
        }).registerHelper("test", (Helper)new AbstractHelper(){

            public void execute(Options options) {
                options.append((CharSequence)options.getValue("key").toString());
            }
        }).build();
        Assert.assertEquals((Object)"foo", (Object)engine.compileMustache("helper_getvalue", "{{test}}").render((Object)"bar"));
        Assert.assertTrue((boolean)released.get());
    }

    @Test
    public void testAsyncExecution() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().setExecutorService(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors())).omitServiceLoaderConfigurationExtensions().registerHelper("async", (Helper)new AbstractHelper(){

            public void execute(Options options) {
                options.executeAsync(o -> {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    o.append((CharSequence)"done");
                });
            }
        }).build();
        Assert.assertEquals((Object)"done my friend", (Object)engine.compileMustache("helper_asynexec", "{{async}} my friend").render((Object)"bar"));
    }

    @Test
    public void testSource() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)new MapTemplateLocator(ImmutableMap.of((Object)"foo", (Object)"{{this}}"))).registerHelper("test", (Helper)new AbstractHelper(){

            public void execute(Options options) {
                this.append(options, options.source(options.getParameters().get(0).toString()));
            }
        }).build();
        Assert.assertEquals((Object)"{{this}}", (Object)engine.compileMustache("helper_source01", "{{test 'foo'}}").render(null));
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_INVALID_PARTIAL_KEY).check(() -> engine.compileMustache("helper_source02", "{{test 'bar'}}").render(null));
    }

    @Test
    public void testOriginalDefinition() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("foo", o -> o.append((CharSequence)((HelperDefinition.ValuePlaceholder)o.getOriginalDefinition().getHash().get("test")).getName())).build();
        Assert.assertEquals((Object)"bar", (Object)engine.compileMustache("helper_origdef01", "{{foo test=bar}}").render(null));
        Assert.assertEquals((Object)"[bar,'1',2]", (Object)engine.compileMustache("helper_origdef01", "{{foo test=[bar,'1',2]}}").render(null));
    }
}

