/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.spec;

import java.util.HashMap;
import java.util.Map;
import org.trimou.lambda.Lambda;
import org.trimou.lambda.SpecCompliantLambda;

public final class Lambdas {
    public static final Map<String, Lambda> testMap = Lambdas.init();

    private static Map<String, Lambda> init() {
        HashMap<String, Lambda> lambdas = new HashMap<String, Lambda>();
        lambdas.put("Interpolation", (Lambda)new SpecCompliantLambda(){

            public String invoke(String text) {
                return "world";
            }
        });
        lambdas.put("Interpolation - Expansion", (Lambda)new SpecCompliantLambda(){

            public String invoke(String text) {
                return "{{planet}}";
            }
        });
        lambdas.put("Interpolation - Multiple Calls", (Lambda)new SpecCompliantLambda(){
            private int calls = 0;

            public String invoke(String text) {
                ++this.calls;
                return "" + this.calls;
            }
        });
        lambdas.put("Escaping", (Lambda)new SpecCompliantLambda(){

            public String invoke(String text) {
                return ">";
            }
        });
        lambdas.put("Interpolation - Alternate Delimiters", (Lambda)new SpecCompliantLambda(){

            public String invoke(String text) {
                return "|planet| => {{planet}}";
            }
        });
        lambdas.put("Section", (Lambda)new SpecCompliantLambda(){

            public String invoke(String text) {
                return text.equals("{{x}}") ? "yes" : "no";
            }
        });
        lambdas.put("Section - Expansion", (Lambda)new SpecCompliantLambda(){

            public String invoke(String text) {
                return text + "{{planet}}" + text;
            }
        });
        lambdas.put("Section - Alternate Delimiters", (Lambda)new SpecCompliantLambda(){

            public String invoke(String text) {
                return text + "{{planet}} => |planet|" + text;
            }
        });
        lambdas.put("Section - Multiple Calls", (Lambda)new SpecCompliantLambda(){

            public String invoke(String text) {
                return "__" + text + "__";
            }
        });
        lambdas.put("Inverted Section", (Lambda)new SpecCompliantLambda(){

            public String invoke(String text) {
                return "false";
            }
        });
        return lambdas;
    }
}

