/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.convert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import org.trimou.engine.convert.Converter;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;

public class ObjectToDateConverter
implements Converter<Object, Date> {
    private final String pattern;

    public ObjectToDateConverter() {
        this(null);
    }

    public ObjectToDateConverter(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public Date convert(Object value) {
        Date converted = null;
        if (value instanceof Date) {
            converted = (Date)value;
        } else if (value instanceof Calendar) {
            converted = ((Calendar)value).getTime();
        } else if (value instanceof LocalDateTime) {
            converted = Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
        } else if (value instanceof LocalDate) {
            converted = Date.from(((LocalDate)value).atStartOfDay(ZoneId.systemDefault()).toInstant());
        } else if (value instanceof Long) {
            converted = new Date((Long)value);
        } else if (value instanceof String && this.pattern != null) {
            try {
                converted = new SimpleDateFormat(this.pattern).parse((String)value);
            }
            catch (ParseException e) {
                throw new MustacheException(MustacheProblem.RENDER_GENERIC_ERROR, "Unable to parse the string value %s using pattern %s", value, this.pattern);
            }
        }
        return converted;
    }
}

