/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.segment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.context.ExecutionContext;
import org.trimou.engine.context.ValueWrapper;
import org.trimou.engine.interpolation.LiteralSupport;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.AsyncAppendable;
import org.trimou.engine.segment.ContainerSegment;
import org.trimou.engine.segment.HelperAwareSegment;
import org.trimou.engine.segment.Segment;
import org.trimou.engine.segment.Segments;
import org.trimou.engine.segment.ValueProvider;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.Options;
import org.trimou.util.Checker;
import org.trimou.util.ImmutableList;
import org.trimou.util.ImmutableMap;
import org.trimou.util.Strings;

class HelperExecutionHandler {
    private final Helper helper;
    private final OptionsBuilder optionsBuilder;

    private HelperExecutionHandler(Helper helper, OptionsBuilder optionsBuilder) {
        this.helper = helper;
        this.optionsBuilder = optionsBuilder;
    }

    static HelperExecutionHandler from(String name, MustacheEngine engine, HelperAwareSegment segment) {
        Iterator<String> parts = HelperExecutionHandler.splitHelperName(name, segment);
        Helper helper = engine.getConfiguration().getHelpers().get(parts.next());
        if (helper == null) {
            return null;
        }
        ImmutableList.ImmutableListBuilder<Object> params = ImmutableList.builder();
        ImmutableMap.ImmutableMapBuilder<String, Object> hash = ImmutableMap.builder();
        LiteralSupport literalSupport = engine.getConfiguration().getLiteralSupport();
        while (parts.hasNext()) {
            String part = parts.next();
            if (Strings.isListLiteral(part)) {
                params.add(new ListValuePlaceholder(part, engine, literalSupport, segment));
                continue;
            }
            int equalsPosition = HelperExecutionHandler.getFirstDeterminingEqualsCharPosition(part);
            if (equalsPosition != -1) {
                String value = part.substring(equalsPosition + 1, part.length());
                if (Strings.isListLiteral(value)) {
                    hash.put(part.substring(0, equalsPosition), new ListValuePlaceholder(value, engine, literalSupport, segment));
                    continue;
                }
                hash.put(part.substring(0, equalsPosition), HelperExecutionHandler.getLiteralOrPlaceholder(value, engine, segment, literalSupport));
                continue;
            }
            params.add(HelperExecutionHandler.getLiteralOrPlaceholder(part, engine, segment, literalSupport));
        }
        OptionsBuilder optionsBuilder = new OptionsBuilder(params.build(), hash.build(), segment, engine);
        helper.validate(optionsBuilder);
        return new HelperExecutionHandler(helper, optionsBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Appendable execute(Appendable appendable, ExecutionContext executionContext) {
        DefaultOptions options = this.optionsBuilder.build(appendable, executionContext);
        try {
            this.helper.execute(options);
            Appendable appendable2 = options.getAppendable();
            return appendable2;
        }
        finally {
            options.release();
        }
    }

    static Iterator<String> splitHelperName(String name, Segment segment) {
        boolean stringLiteral = false;
        boolean arrayLiteral = false;
        boolean space = false;
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == ' ') {
                if (space) continue;
                if (!stringLiteral && !arrayLiteral) {
                    if (buffer.length() > 0) {
                        parts.add(buffer.toString());
                        buffer = new StringBuilder();
                    }
                    space = true;
                    continue;
                }
                buffer.append(name.charAt(i));
                continue;
            }
            if (!arrayLiteral && Strings.isStringLiteralSeparator(name.charAt(i))) {
                stringLiteral = !stringLiteral;
            } else if (!stringLiteral && Strings.isListLiteralStart(name.charAt(i))) {
                arrayLiteral = true;
            } else if (!stringLiteral && Strings.isListLiteralEnd(name.charAt(i))) {
                arrayLiteral = false;
            }
            space = false;
            buffer.append(name.charAt(i));
        }
        if (buffer.length() > 0) {
            if (stringLiteral || arrayLiteral) {
                throw new MustacheException(MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE, "Unterminated string or array literal detected: %s", segment);
            }
            parts.add(buffer.toString());
        }
        return parts.iterator();
    }

    static int getFirstDeterminingEqualsCharPosition(String part) {
        boolean stringLiteral = false;
        for (int i = 0; i < part.length(); ++i) {
            if (Strings.isStringLiteralSeparator(part.charAt(i))) {
                if (i == 0) {
                    return -1;
                }
                stringLiteral = !stringLiteral;
                continue;
            }
            if (stringLiteral || part.charAt(i) != '=') continue;
            return i;
        }
        return -1;
    }

    private static Object getLiteralOrPlaceholder(String value, MustacheEngine engine, HelperAwareSegment segment, LiteralSupport literalSupport) {
        Object literal = literalSupport.getLiteral(value, segment.getTagInfo());
        return literal != null ? literal : new DefaultValuePlaceholder(value, engine);
    }

    private static class ListValuePlaceholder
    implements HelperDefinition.ValuePlaceholder,
    Iterable<Object> {
        private final boolean hasValuePlaceholderElement;
        private final List<Object> values;
        private final String name;

        ListValuePlaceholder(String value, MustacheEngine engine, LiteralSupport literalSupport, HelperAwareSegment segment) {
            List<String> elements = Strings.split(value.substring(1, value.length() - 1), ",");
            ImmutableList.ImmutableListBuilder<Object> builder = ImmutableList.builder();
            for (String element : elements) {
                builder.add(HelperExecutionHandler.getLiteralOrPlaceholder(element.trim(), engine, segment, literalSupport));
            }
            this.values = builder.build();
            this.hasValuePlaceholderElement = this.initHasValuePlaceholderElement();
            this.name = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Iterator<Object> iterator() {
            return this.values.iterator();
        }

        List<Object> getValues() {
            return this.values;
        }

        private boolean initHasValuePlaceholderElement() {
            for (Object val : this.values) {
                if (!(val instanceof HelperDefinition.ValuePlaceholder)) continue;
                return true;
            }
            return false;
        }
    }

    private static class DefaultValuePlaceholder
    implements HelperDefinition.ValuePlaceholder {
        private final String name;
        private final ValueProvider provider;

        DefaultValuePlaceholder(String name, MustacheEngine engine) {
            this.name = name;
            this.provider = new ValueProvider(name, engine.getConfiguration());
        }

        @Override
        public String getName() {
            return this.name;
        }

        ValueProvider getProvider() {
            return this.provider;
        }
    }

    private static class DefaultOptions
    implements Options {
        private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOptions.class);
        protected List<ValueWrapper> valueWrappers;
        protected Appendable appendable;
        protected int pushed;
        protected ExecutionContext executionContext;
        private final MustacheEngine engine;
        private final HelperAwareSegment segment;
        private final List<Object> parameters;
        private final Map<String, Object> hash;
        private final HelperDefinition originalDefinition;

        DefaultOptions(Appendable appendable, ExecutionContext executionContext, HelperAwareSegment segment, List<Object> parameters, Map<String, Object> hash, List<ValueWrapper> valueWrappers, MustacheEngine engine, HelperDefinition originalDefinition) {
            this.appendable = appendable;
            this.valueWrappers = valueWrappers;
            this.executionContext = executionContext;
            this.pushed = 0;
            this.segment = segment;
            this.parameters = parameters;
            this.hash = hash;
            this.engine = engine;
            this.originalDefinition = originalDefinition;
        }

        @Override
        public List<Object> getParameters() {
            return this.parameters;
        }

        @Override
        public Map<String, Object> getHash() {
            return this.hash;
        }

        @Override
        public void append(CharSequence sequence) {
            try {
                this.appendable.append(sequence);
            }
            catch (IOException e) {
                throw new MustacheException(MustacheProblem.RENDER_IO_ERROR, (Throwable)e);
            }
        }

        @Override
        public void fn() {
            this.appendable = this.segment.fn(this.appendable, this.executionContext);
        }

        @Override
        public void partial(String templateId) {
            this.partial(templateId, this.appendable);
        }

        @Override
        public void push(Object contextObject) {
            ++this.pushed;
            this.executionContext = this.executionContext.setContextObject(contextObject);
        }

        @Override
        public Object pop() {
            if (this.pushed > 0) {
                --this.pushed;
                Object top = this.executionContext.getFirstContextObject();
                this.executionContext = this.executionContext.getParent();
                return top;
            }
            throw new MustacheException(MustacheProblem.RENDER_HELPER_INVALID_POP_OPERATION);
        }

        @Override
        public Object peek() {
            return this.executionContext.getFirstContextObject();
        }

        @Override
        public Object getValue(String key) {
            if (this.valueWrappers == null) {
                this.valueWrappers = new ArrayList<ValueWrapper>(5);
            }
            ValueWrapper wrapper = this.executionContext.getValue(key);
            this.valueWrappers.add(wrapper);
            return wrapper.get();
        }

        @Override
        public void partial(String templateId, Appendable appendable) {
            this.partial(templateId, appendable, this.executionContext);
        }

        @Override
        public void executeAsync(Options.HelperExecutable executable) {
            AsyncAppendable asyncAppendable = new AsyncAppendable(this.appendable);
            ExecutorService executor = this.engine.getConfiguration().geExecutorService();
            if (executor == null) {
                throw new MustacheException(MustacheProblem.RENDER_ASYNC_PROCESSING_ERROR, "ExecutorService must be set in order to submit an asynchronous task", new Object[0]);
            }
            Future<AsyncAppendable> future = executor.submit(() -> {
                DefaultOptions asyncOptions = new DefaultOptions(new AsyncAppendable(asyncAppendable), this.executionContext, this.segment, this.parameters, this.hash, new ArrayList<ValueWrapper>(), this.engine, this.originalDefinition);
                executable.execute(asyncOptions);
                return (AsyncAppendable)asyncOptions.getAppendable();
            });
            asyncAppendable.setFuture(future);
            this.appendable = asyncAppendable;
        }

        @Override
        public String source(String templateId) {
            Checker.checkArgumentNotEmpty(templateId);
            String mustacheSource = this.engine.getMustacheSource(templateId);
            if (mustacheSource == null) {
                throw new MustacheException(MustacheProblem.RENDER_INVALID_PARTIAL_KEY, "No mustache template found for the given key: %s %s", templateId, this.segment.getOrigin());
            }
            return mustacheSource;
        }

        @Override
        public Appendable getAppendable() {
            return this.appendable;
        }

        @Override
        public void fn(Appendable appendable) {
            this.segment.fn(appendable, this.executionContext);
        }

        @Override
        public MustacheTagInfo getTagInfo() {
            return this.segment.getTagInfo();
        }

        @Override
        public String getContentLiteralBlock() {
            if (this.segment instanceof ContainerSegment) {
                return ((ContainerSegment)((Object)this.segment)).getContentLiteralBlock();
            }
            return "";
        }

        @Override
        public HelperDefinition getOriginalDefinition() {
            return this.originalDefinition;
        }

        protected void partial(String templateId, Appendable appendable, ExecutionContext executionContext) {
            Checker.checkArgumentsNotNull(templateId, appendable);
            Template partialTemplate = Segments.lookupTemplate(templateId, this.engine, this.segment.getOrigin().getTemplate());
            if (partialTemplate == null) {
                throw new MustacheException(MustacheProblem.RENDER_INVALID_PARTIAL_KEY, "No partial found for the given key: %s %s", templateId, this.segment.getOrigin());
            }
            partialTemplate.getRootSegment().execute(appendable, executionContext);
        }

        void release() {
            if (this.valueWrappers != null) {
                int wrappersSize = this.valueWrappers.size();
                if (wrappersSize == 1) {
                    this.valueWrappers.get(0).release();
                } else if (wrappersSize > 1) {
                    for (ValueWrapper wrapper : this.valueWrappers) {
                        wrapper.release();
                    }
                }
            }
            if (this.pushed > 0) {
                LOGGER.info("{} remaining objects pushed on the context stack will be automatically garbage collected [helperName: {}, template: {}]", new Object[]{this.pushed, HelperExecutionHandler.splitHelperName(this.segment.getTagInfo().getText(), this.segment).next(), this.segment.getTagInfo().getTemplateName()});
            }
        }
    }

    private static class OptionsBuilder
    implements HelperDefinition {
        private final List<Object> parameters;
        private final Map<String, Object> hash;
        private final HelperAwareSegment segment;
        private final MustacheEngine engine;
        private final boolean isParamValuePlaceholderFound;
        private final boolean isHashValuePlaceholderFound;

        private OptionsBuilder(List<Object> parameters, Map<String, Object> hash, HelperAwareSegment segment, MustacheEngine engine) {
            this.parameters = parameters;
            this.hash = hash;
            this.segment = segment;
            this.engine = engine;
            this.isParamValuePlaceholderFound = this.initParamValuePlaceholderFound(parameters);
            this.isHashValuePlaceholderFound = this.initHashValuePlaceholderFound(hash);
        }

        @Override
        public MustacheTagInfo getTagInfo() {
            return this.segment.getTagInfo();
        }

        @Override
        public List<Object> getParameters() {
            return this.parameters;
        }

        @Override
        public Map<String, Object> getHash() {
            return this.hash;
        }

        @Override
        public String getContentLiteralBlock() {
            if (this.segment instanceof ContainerSegment) {
                return ((ContainerSegment)((Object)this.segment)).getContentLiteralBlock();
            }
            return "";
        }

        public DefaultOptions build(Appendable appendable, ExecutionContext executionContext) {
            LinkedList<ValueWrapper> valueWrappers = this.isParamValuePlaceholderFound || this.isHashValuePlaceholderFound ? new LinkedList<ValueWrapper>() : null;
            return new DefaultOptions(appendable, executionContext, this.segment, this.getFinalParameters(executionContext, valueWrappers), this.getFinalHash(executionContext, valueWrappers), valueWrappers, this.engine, this);
        }

        private List<Object> getFinalParameters(ExecutionContext executionContext, List<ValueWrapper> valueWrappers) {
            if (this.isParamValuePlaceholderFound) {
                int size = this.parameters.size();
                switch (size) {
                    case 1: {
                        return Collections.singletonList(this.resolveValue(this.parameters.get(0), valueWrappers, executionContext));
                    }
                }
                ArrayList<Object> finalParams = new ArrayList<Object>(size);
                for (Object param : this.parameters) {
                    finalParams.add(this.resolveValue(param, valueWrappers, executionContext));
                }
                return Collections.unmodifiableList(finalParams);
            }
            return this.parameters;
        }

        private Map<String, Object> getFinalHash(ExecutionContext executionContext, List<ValueWrapper> valueWrappers) {
            if (this.isHashValuePlaceholderFound) {
                int size = this.hash.size();
                switch (size) {
                    case 1: {
                        Map.Entry<String, Object> singleEntry = this.hash.entrySet().iterator().next();
                        return Collections.singletonMap(singleEntry.getKey(), this.resolveValue(singleEntry.getValue(), valueWrappers, executionContext));
                    }
                }
                HashMap<String, Object> finalHash = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entry : this.hash.entrySet()) {
                    finalHash.put(entry.getKey(), this.resolveValue(entry.getValue(), valueWrappers, executionContext));
                }
                return Collections.unmodifiableMap(finalHash);
            }
            return this.hash;
        }

        private Object resolveValue(Object value, List<ValueWrapper> valueWrappers, ExecutionContext executionContext) {
            if (value instanceof HelperDefinition.ValuePlaceholder) {
                if (value instanceof ListValuePlaceholder) {
                    ListValuePlaceholder listValues = (ListValuePlaceholder)value;
                    if (listValues.hasValuePlaceholderElement) {
                        ImmutableList.ImmutableListBuilder<Object> builder = ImmutableList.builder();
                        for (Object element : listValues) {
                            builder.add(this.resolveValue(element, valueWrappers, executionContext));
                        }
                        return builder.build();
                    }
                    return listValues.getValues();
                }
                ValueWrapper wrapper = value instanceof DefaultValuePlaceholder ? ((DefaultValuePlaceholder)value).getProvider().get(executionContext) : executionContext.getValue(((HelperDefinition.ValuePlaceholder)value).getName());
                valueWrappers.add(wrapper);
                return wrapper.get();
            }
            return value;
        }

        private boolean initParamValuePlaceholderFound(List<Object> parameters) {
            if (parameters.isEmpty()) {
                return false;
            }
            for (Object param : parameters) {
                if (!(param instanceof HelperDefinition.ValuePlaceholder)) continue;
                return true;
            }
            return false;
        }

        private boolean initHashValuePlaceholderFound(Map<String, Object> hash) {
            if (hash.isEmpty()) {
                return false;
            }
            for (Map.Entry<String, Object> entry : hash.entrySet()) {
                if (!(entry.getValue() instanceof HelperDefinition.ValuePlaceholder)) continue;
                return true;
            }
            return false;
        }
    }
}

