/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.util.HashMap;
import java.util.Map;
import org.trimou.annotations.Internal;
import org.trimou.util.Checker;
import org.trimou.util.ImmutableMap;

@Internal
public final class Primitives {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER;

    private Primitives() {
    }

    public static <T> Class<T> wrap(Class<T> type) {
        Checker.checkArgumentNotNull(type);
        Class<?> wrapped = PRIMITIVE_TO_WRAPPER.get(type);
        return wrapped != null ? wrapped : type;
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Class> primitiveToWrapper = new HashMap<Class<Comparable<Boolean>>, Class>();
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER = ImmutableMap.copyOf(primitiveToWrapper);
    }
}

