/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.listener;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.listener.SimpleStatsCollector;
import org.trimou.lambda.InputLiteralLambda;

public class SimpleStatsCollectorTest
extends AbstractEngineTest {
    @Override
    @Before
    public void buildEngine() {
    }

    @Test
    public void testDataCollecting() {
        SimpleStatsCollector collector = new SimpleStatsCollector();
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addMustacheListener((MustacheListener)collector).build();
        InputLiteralLambda sleeper = new InputLiteralLambda(){
            final Random random = new Random();

            public boolean isReturnValueInterpolated() {
                return false;
            }

            public String invoke(String text) {
                try {
                    Thread.sleep(10L + (long)this.random.nextInt(10));
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException();
                }
                return text;
            }
        };
        Mustache mustache = engine.compileMustache("foo", "{{this}}");
        int loop = 50;
        for (int i = 0; i < loop; ++i) {
            mustache.render((Object)sleeper);
        }
        Assert.assertNull((Object)collector.getSimpleStats("unknown"));
        SimpleStatsCollector.SimpleStats statistics = collector.getSimpleStats("foo");
        Assert.assertNotNull((Object)statistics);
        Assert.assertEquals((long)loop, (long)statistics.getExecutions());
        System.out.println(statistics);
        Assert.assertEquals((long)1L, (long)collector.getSimpleStats().size());
        Assert.assertNull((Object)collector.getData("fooooo"));
        Map data = collector.getData("foo");
        Assert.assertNotNull((Object)data);
        long totalExecutions = 0L;
        for (Long executions : data.values()) {
            totalExecutions += executions.longValue();
        }
        Assert.assertEquals((long)loop, (long)totalExecutions);
        Assert.assertEquals((long)1L, (long)collector.getData().size());
    }

    @Test
    public void testClearData() {
        SimpleStatsCollector collector = new SimpleStatsCollector();
        Mustache mustache = MustacheEngineBuilder.newBuilder().addMustacheListener((MustacheListener)collector).build().compileMustache("bar", "BAR");
        mustache.render(null);
        Assert.assertEquals((long)1L, (long)collector.getSimpleStats("bar").getExecutions());
        collector.clearData();
        Assert.assertNull((Object)collector.getSimpleStats("bar"));
    }

    @Test
    public void testCustomPredicate() {
        SimpleStatsCollector collector = new SimpleStatsCollector(t -> false, TimeUnit.DAYS);
        Mustache mustache = MustacheEngineBuilder.newBuilder().addMustacheListener((MustacheListener)collector).build().compileMustache("qux", "Oops");
        mustache.render(null);
        Assert.assertNull((Object)collector.getSimpleStats("qux"));
    }
}

