/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.parser;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.EngineConfigurationKey;
import org.trimou.engine.locator.MapTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.parser.ParsingTest;
import org.trimou.engine.parser.Template;
import org.trimou.engine.segment.SegmentType;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;

public class NestedTemplateTest
extends AbstractEngineTest {
    @Test
    public void testBasicNestedTemplate() {
        Assert.assertEquals((Object)"Hello world!", (Object)this.engine.compileMustache("nested_basic01", "{{+nested}}world{{/nested}}Hello {{>nested}}!").render(null));
        Assert.assertEquals((Object)"Hello world!", (Object)this.engine.compileMustache("nested_basic02", "{{+hello}}Hello{{/hello}} {{+world}}world{{/world}} {{>hello}} {{>world}}!").render(null).trim());
    }

    @Test
    public void testDependentNestedTemplates() {
        Assert.assertEquals((Object)"Hello world!", (Object)this.engine.compileMustache("nested_dependent", "{{+nested1}}world{{/nested1}}{{+nested2}}{{>nested1}}{{/nested2}}Hello {{>nested2}}!").render(null));
    }

    @Test
    public void testNestedTemplateIsPreferred() {
        this.engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)MapTemplateLocator.builder().put("foo", "bar").build()).build();
        Assert.assertEquals((Object)"Hello world!", (Object)this.engine.compileMustache("nested_preferred", "{{+foo}}world{{/foo}}Hello {{>foo}}!").render(null));
    }

    @Test
    public void testNestedHierarchyNotSupported() {
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_NESTED_TEMPLATE_ERROR).check(() -> this.engine.compileMustache("nested_hierarchy", "{{+nested}}{{+foo}}not supported{{/foo}}{{/nested}}!"));
    }

    @Test
    public void testInvalidDefinition() {
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_INVALID_TEMPLATE).check(() -> this.engine.compileMustache("nested_invalid_definition", "{{+nested}}not supported!"));
    }

    @Test
    public void testNestedTemplateIsNotASegment() {
        Template template = (Template)this.engine.compileMustache("nested_notsegment", "{{+nested}}world{{/nested}}Hello {{>nested}}!");
        List segments = template.getRootSegment().getSegments();
        Assert.assertEquals((long)3L, (long)segments.size());
        ParsingTest.validateSegment(segments, 0, SegmentType.TEXT, "Hello ");
        ParsingTest.validateSegment(segments, 1, SegmentType.PARTIAL, "nested");
        ParsingTest.validateSegment(segments, 2, SegmentType.TEXT, "!");
    }

    @Test
    public void testNestedTemplateSupportDisabled() {
        this.engine = MustacheEngineBuilder.newBuilder().addGlobalData("+foo", (Object)"Hello").setProperty((ConfigurationKey)EngineConfigurationKey.NESTED_TEMPLATE_SUPPORT_ENABLED, (Object)false).build();
        Assert.assertEquals((Object)"Hello world!", (Object)this.engine.compileMustache("nested_disabled", "{{+foo}} world!").render(null));
    }

    @Test
    public void testDuplicitNamesNotAllowed() {
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_NESTED_TEMPLATE_ERROR).check(() -> this.engine.compileMustache("nested_duplicit_names", "{{+nested}}foo{{/nested}}{{+nested}}bar{{/nested}}!"));
    }

    @Test
    public void testDependentNestedTemplatesHelper() {
        this.engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addInclude().build()).build();
        Assert.assertEquals((Object)"Hello world!", (Object)this.engine.compileMustache("nested_dependent", "{{+nested1}}world{{/nested1}}{{+nested2}}{{include 'nested1'}}{{/nested2}}Hello {{include 'nested2'}}!").render(null));
    }
}

