/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.Mustache;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;
import org.trimou.util.ImmutableList;

public class RepeatHelperTest
extends AbstractTest {
    @Test
    public void testHelper() throws InterruptedException {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addRepeat().addInvoke().build()).build();
        Assert.assertEquals((Object)"mememe", (Object)engine.compileMustache("repeat_01", "{{#repeat times=3}}me{{/repeat}}").render(null));
        Assert.assertEquals((Object)"", (Object)engine.compileMustache("repeat_02", "{{#repeat while=this}}me{{/repeat}}").render((Object)false));
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_GENERIC_ERROR).check(() -> engine.compileMustache("repeat_03", "{{#repeat while='this' limit=3}}me{{/repeat}}").render((Object)true));
        Assert.assertEquals((Object)"foobar", (Object)engine.compileMustache("repeat_04", "{{#with this.iterator}}{{#repeat while=hasNext}}{{next}}{{/repeat}}{{/with}}").render((Object)ImmutableList.of((Object[])new String[]{"foo", "bar"})));
        Assert.assertEquals((Object)"barfoo", (Object)engine.compileMustache("repeat_05", "{{#invoke this.size on=this m='listIterator'}}{{#repeat while=hasPrevious}}{{previous}}{{/repeat}}{{/invoke}}").render((Object)ImmutableList.of((Object[])new String[]{"foo", "bar"})));
    }

    @Test
    public void testValidation() {
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(() -> MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addRepeat().build()).build().compileMustache("repeat_validation_01", "{{repeat}}")).check(() -> MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addRepeat().build()).build().compileMustache("repeat_validation_02", "{{#repeat foo='bar'}}{{/repeat}}")).check(() -> MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addRepeat().build()).build().compileMustache("repeat_validation_03", "{{#repeat times='a'}}{{/repeat}}"));
    }

    @Test
    public void testStreamIteration() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addRepeat().build()).build();
        List data = ImmutableList.of((Object[])new String[]{"foo", "baz", "foos"});
        Mustache mustache = engine.compileMustache("stream", "{{#with this.sequential.iterator}}{{#repeat while=hasNext}}{{next}}/{{/repeat}}{{/with}}");
        Assert.assertEquals((Object)"foo/baz/", (Object)mustache.render(data.stream().filter(e -> e.toString().length() == 3)));
    }
}

