/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;

public class TagHelperTest
extends AbstractTest {
    @Test
    public void testHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addTag().build()).build();
        Assert.assertEquals((Object)"{{foo}}", (Object)engine.compileMustache("tag_helper1", "{{tag 'foo'}}").render(null));
        Assert.assertEquals((Object)"{{#each items as=\"item\"}}{{this}}{{/each}}", (Object)engine.compileMustache("tag_helper2", "{{#tag 'each' 'items as=\"item\"'}}{{tag 'this'}}{{/tag}}").render(null));
        Assert.assertEquals((Object)"{{foo bar apply=\"me\"}}", (Object)engine.compileMustache("tag_helper3", "{{tag 'foo' this ' apply=\"me\"'}}").render((Object)"bar"));
    }

    @Test
    public void testHelperValidation() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addTag().build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(() -> engine.compileMustache("tag_helper_validation01", "{{tag}}"));
    }
}

