/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.util.Strings;

public final class BuildInfo {
    public static final String BUILD_PROPERTIES_FILE = "/trimou-build.properties";
    private final String version;
    private final String timestamp;

    public static BuildInfo load() {
        String version = null;
        String timestamp = null;
        try (InputStream in = MustacheEngineBuilder.class.getResourceAsStream(BUILD_PROPERTIES_FILE);){
            if (in != null) {
                Properties buildProperties = new Properties();
                buildProperties.load(in);
                version = buildProperties.getProperty("version");
                timestamp = buildProperties.getProperty("timestamp");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (version == null) {
            version = MustacheEngineBuilder.class.getPackage().getImplementationVersion();
        }
        if (Strings.isEmpty(version)) {
            version = "SNAPSHOT";
        }
        if (Strings.isEmpty(timestamp)) {
            timestamp = "n/a";
        }
        return new BuildInfo(version, timestamp);
    }

    private BuildInfo(String version, String timestamp) {
        this.version = version;
        this.timestamp = timestamp;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getTimestampDate() {
        int idx = this.timestamp.indexOf(84);
        if (idx > 0) {
            return this.timestamp.substring(0, idx);
        }
        return this.timestamp;
    }

    public String toString() {
        return "BuildInfo [version=" + this.version + ", timestamp=" + this.timestamp + "]";
    }
}

