/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.handlebars.AbstractHelper;
import org.trimou.handlebars.Helper;
import org.trimou.handlebars.HelperDefinition;
import org.trimou.handlebars.Options;
import org.trimou.util.Checker;

public final class SimpleHelpers {
    private SimpleHelpers() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Helper execute(BiConsumer<Options, Configuration> executionCallback) {
        return SimpleHelpers.builder().execute(executionCallback).build();
    }

    static class SimpleHelper
    extends AbstractHelper {
        private final Set<ConfigurationKey> configurationKeys;
        private final BiConsumer<Options, Configuration> executionCallback;
        private final BiConsumer<HelperDefinition, Configuration> validationCallback;

        private SimpleHelper(Set<ConfigurationKey> configurationKeys, BiConsumer<Options, Configuration> executionCallback, BiConsumer<HelperDefinition, Configuration> validationCallback) {
            Checker.checkArgumentNotNull(executionCallback);
            this.configurationKeys = configurationKeys == null ? Collections.emptySet() : configurationKeys;
            this.executionCallback = executionCallback;
            this.validationCallback = validationCallback;
        }

        @Override
        public void execute(Options options) {
            this.executionCallback.accept(options, this.configuration);
        }

        @Override
        public void validate(HelperDefinition definition) {
            if (this.validationCallback != null) {
                this.validationCallback.accept(definition, this.configuration);
            }
        }

        @Override
        public Set<ConfigurationKey> getConfigurationKeys() {
            return this.configurationKeys;
        }
    }

    public static class Builder {
        private Set<ConfigurationKey> configurationKeys;
        private BiConsumer<Options, Configuration> executionCallback;
        private BiConsumer<HelperDefinition, Configuration> validationCallback;

        public Builder execute(BiConsumer<Options, Configuration> executionCallback) {
            this.executionCallback = executionCallback;
            return this;
        }

        public Builder validate(BiConsumer<HelperDefinition, Configuration> validationCallback) {
            this.validationCallback = validationCallback;
            return this;
        }

        public Builder addConfigurationKey(ConfigurationKey key) {
            if (this.configurationKeys == null) {
                this.configurationKeys = new HashSet<ConfigurationKey>();
            }
            this.configurationKeys.add(key);
            return this;
        }

        public Helper build() {
            return new SimpleHelper(this.configurationKeys, this.executionCallback, this.validationCallback);
        }
    }
}

