/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.listener;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.listener.AbstractMustacheListener;
import org.trimou.engine.listener.MustacheCompilationEvent;
import org.trimou.engine.listener.MustacheListener;
import org.trimou.engine.listener.MustacheParsingEvent;
import org.trimou.engine.listener.MustacheRenderingEvent;
import org.trimou.lambda.SpecCompliantLambda;

public class MustacheListenerTest
extends AbstractEngineTest {
    @Override
    @Before
    public void buildEngine() {
    }

    @Test
    public void testListenersInvoked() {
        final ArrayList parsed = new ArrayList();
        final ArrayList compiled = new ArrayList();
        final ArrayList renderingStarts = new ArrayList();
        final ArrayList renderingEnds = new ArrayList();
        SpecCompliantLambda lambda = new SpecCompliantLambda(){

            public String invoke(String text) {
                return "foo";
            }
        };
        AbstractMustacheListener listener1 = new AbstractMustacheListener(){

            public void renderingStarted(MustacheRenderingEvent event) {
                renderingStarts.add(event.getMustacheName());
            }

            public void renderingFinished(MustacheRenderingEvent event) {
                renderingEnds.add(event.getMustacheName());
            }

            public void compilationFinished(MustacheCompilationEvent event) {
                compiled.add(event.getMustache().getName());
            }
        };
        AbstractMustacheListener listener2 = new AbstractMustacheListener(){

            public void renderingStarted(MustacheRenderingEvent event) {
                renderingStarts.add(event.getMustacheName() + "2");
            }

            public void renderingFinished(MustacheRenderingEvent event) {
                renderingEnds.add(event.getMustacheName() + "2");
            }

            public void parsingStarted(MustacheParsingEvent event) {
                parsed.add(event.getMustacheName() + "2");
            }
        };
        Assert.assertEquals((Object)"foo", (Object)MustacheEngineBuilder.newBuilder().addGlobalData("bar", (Object)lambda).addMustacheListener((MustacheListener)listener1).addMustacheListener((MustacheListener)listener2).build().compileMustache("listeners", "{{bar}}").render(null));
        Assert.assertEquals((long)2L, (long)compiled.size());
        Assert.assertEquals((Object)"listeners", compiled.get(0));
        Assert.assertEquals((long)2L, (long)renderingStarts.size());
        Assert.assertEquals((Object)"listeners", renderingStarts.get(0));
        Assert.assertEquals((Object)"listeners2", renderingStarts.get(1));
        Assert.assertEquals((long)2L, (long)renderingEnds.size());
        Assert.assertEquals((Object)"listeners2", renderingEnds.get(0));
        Assert.assertEquals((Object)"listeners", renderingEnds.get(1));
        Assert.assertEquals((long)2L, (long)parsed.size());
        Assert.assertEquals((Object)"listeners2", parsed.get(0));
    }

    @Test
    public void testListenerThrowsUncheckedException() {
        final ArrayList renderingStarts = new ArrayList();
        final ArrayList renderingEnds = new ArrayList();
        final AtomicBoolean callbackInvoked = new AtomicBoolean(false);
        AbstractMustacheListener listener1 = new AbstractMustacheListener(){

            public void renderingStarted(MustacheRenderingEvent event) {
                renderingStarts.add(event.getMustacheName());
            }

            public void renderingFinished(MustacheRenderingEvent event) {
                renderingEnds.add(event.getMustacheName());
            }
        };
        AbstractMustacheListener listener2 = new AbstractMustacheListener(){

            public void renderingStarted(MustacheRenderingEvent event) {
                renderingStarts.add(event.getMustacheName() + "2");
                event.registerReleaseCallback(() -> callbackInvoked.set(true));
            }

            public void renderingFinished(MustacheRenderingEvent event) {
                renderingEnds.add(event.getMustacheName() + "2");
                throw new NullPointerException();
            }
        };
        try {
            MustacheEngineBuilder.newBuilder().addMustacheListener((MustacheListener)listener1).addMustacheListener((MustacheListener)listener2).build().compileMustache("listener_throws_unchecked_exception", " ").render(null);
            Assert.fail((String)"Rendering should fail");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)renderingStarts.size());
        Assert.assertEquals((Object)"listener_throws_unchecked_exception", renderingStarts.get(0));
        Assert.assertEquals((Object)"listener_throws_unchecked_exception2", renderingStarts.get(1));
        Assert.assertEquals((long)1L, (long)renderingEnds.size());
        Assert.assertEquals((Object)"listener_throws_unchecked_exception2", renderingEnds.get(0));
        Assert.assertTrue((boolean)callbackInvoked.get());
    }
}

