/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.Hammer;
import org.trimou.engine.resolver.Decorator;

public class DecoratorTest
extends AbstractEngineTest {
    @Test
    public void testInterpolation() {
        Assert.assertEquals((Object)"ooF", (Object)this.engine.compileMustache("{{reverse}}").render((Object)((Decorator.Builder)Decorator.decorate((Object)"Foo").compute("reverse", s -> new StringBuilder((String)s).reverse().toString())).build(this.engine)));
        Hammer hammer = new Hammer();
        Assert.assertEquals((Object)"kladivo EDGAR 10", (Object)this.engine.compileMustache("{{translate}} {{name}} {{age}}").render((Object)((Decorator.Builder)((Decorator.Builder)Decorator.decorate((Object)hammer).put("translate", (Object)"kladivo")).compute("name", h -> h.getName().toUpperCase())).build(this.engine)));
        ArrayList<Hammer> hammers = new ArrayList<Hammer>();
        hammers.add(new Hammer(0));
        hammers.add(new Hammer(1));
        hammers.add(new Hammer(2));
        Assert.assertEquals((Object)"123", (Object)this.engine.compileMustache("{{#each}}{{age}}{{/each}}").render(hammers.stream().map(h -> ((Decorator.Builder)Decorator.decorate((Object)h).put("age", (Object)(h.getAge() + 1))).build(this.engine)).collect(Collectors.toList())));
        int[] array = new int[]{1, 3, 5};
        List<Integer> list = Arrays.asList(1, 3, 5);
        Assert.assertEquals((Object)"1 + 3 + 5 = 9", (Object)this.engine.compileMustache("{{#each}}{{.}}{{#iterHasNext}} + {{/iterHasNext}}{{/each}} = {{sum}}").render((Object)((Decorator.Builder)Decorator.decorate((Object)array).compute("sum", vals -> Arrays.stream(array).sum())).build(this.engine)));
        Assert.assertEquals((Object)"1 + 3 + 5 = 9", (Object)this.engine.compileMustache("{{#each}}{{.}}{{#iterHasNext}} + {{/iterHasNext}}{{/each}} = {{sum}}").render((Object)((Decorator.Builder)Decorator.decorate(list).compute("sum", l -> l.stream().mapToInt(Integer::intValue).sum())).build(this.engine)));
    }

    @Test
    public void testGetDelegate() {
        Hammer hammer = new Hammer();
        Assert.assertEquals((Object)"EDGAR vs Edgar", (Object)this.engine.compileMustache("{{name}} vs {{delegate.name}}").render((Object)((Decorator.Builder)Decorator.decorate((Object)hammer).compute("name", h -> h.getName().toUpperCase())).build(this.engine)));
        Assert.assertEquals((Object)"EDGAR vs Edgar", (Object)this.engine.compileMustache("{{name}} vs {{foo.name}}").render((Object)((Decorator.Builder)((Decorator.Builder)Decorator.decorate((Object)hammer).delegateKey("foo")).compute("name", h -> h.getName().toUpperCase())).build(this.engine)));
    }

    @Test
    public void testNestedDecorator() {
        Hammer hammer = new Hammer(5);
        Assert.assertEquals((Object)"5:Edgar:bar", (Object)this.engine.compileMustache("{{age}}:{{foo}}:{{bar}}").render((Object)((Decorator.Builder)Decorator.decorate((Object)((Decorator.Builder)Decorator.decorate((Object)hammer).compute("foo", h -> h.getName())).build(this.engine)).put("bar", (Object)"bar")).build(this.engine)));
    }
}

