/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.handlebars.DecoratorHelper;
import org.trimou.handlebars.Helper;

public class DecoratorHelperTest
extends AbstractTest {
    @Test
    public void testHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelper("decorateCat", (Helper)((DecoratorHelper.Builder)((DecoratorHelper.Builder)((DecoratorHelper.Builder)DecoratorHelper.decorate(Cat.class).put("const", (Object)"Cat")).compute("name", cat -> cat.getName().toUpperCase())).compute("overweight", cat -> cat.getWeight() > 4500 ? cat.getWeight() - 4500 : 0)).build()).registerHelper("decorateIntList", (Helper)((DecoratorHelper.Builder)DecoratorHelper.decorate(List.class).compute("sum", l -> l.stream().mapToInt(e -> Integer.valueOf(e.toString())).sum())).build()).registerHelper("dummy", (Helper)((DecoratorHelper.Builder)((DecoratorHelper.Builder)DecoratorHelper.decorate(String.class).delegateKey("foo")).compute("toUpperCase", s -> s.toLowerCase())).build()).registerHelper("decorateStr", (Helper)((DecoratorHelper.Builder)DecoratorHelper.decorate(String.class).compute("reverse", s -> new StringBuilder((String)s).reverse().toString())).build()).build();
        Assert.assertEquals((Object)"ooF", (Object)engine.compileMustache("{{#decorateStr}}{{reverse}}{{/decorateStr}}").render((Object)"Foo"));
        ArrayList<Cat> cats = new ArrayList<Cat>();
        cats.add(new Cat("Mikes", 3000));
        cats.add(new Cat("Mourek", 5000));
        Assert.assertEquals((Object)"Cat MIKES [3000g] has overweight 0g.Cat MOUREK [5000g] has overweight 500g.", (Object)engine.compileMustache("{{#each}}{{#decorateCat}}{{const}} {{name}} [{{weight}}g] has overweight {{overweight}}g.{{/decorateCat}}{{/each}}").render(cats));
        try {
            engine.compileMustache("{{#decorateCat}}{{name}}{{/decorateCat}}").render((Object)"foo");
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"6:123", (Object)engine.compileMustache("{{#decorateIntList}}{{sum}}:{{#each}}{{.}}{{/each}}{{/decorateIntList}}").render(Arrays.asList(1, 2, 3)));
        Assert.assertEquals((Object)"lu vs LU", (Object)engine.compileMustache("{{#dummy}}{{toUpperCase}} vs {{foo.toUpperCase}}{{/dummy}}").render((Object)"Lu"));
    }

    class Cat {
        private final String name;
        private final Integer weight;

        public Cat(String name, Integer size) {
            this.name = name;
            this.weight = size;
        }

        public String getName() {
            return this.name;
        }

        public Integer getWeight() {
            return this.weight;
        }
    }
}

