/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.handlebars.MatchingSectionHelper;

public class MatchingSectionHelperTest
extends AbstractTest {
    @Test
    public void testElsePattern() {
        this.assertPattern("{1}", "{", "}", 1, "FOUND");
        this.assertPattern("{foo } and {bar}", "{", "}", 2, "FOUND and FOUND");
        this.assertPattern("$foo $ and {bar}", "$", "$", 1, "FOUND and {bar}");
        this.assertPattern("$foo$ $", "$", "$", 1, "FOUND $");
    }

    private void assertPattern(String text, String start, String end, int expectedOccurences, String expectedResult) {
        Pattern pattern = MatchingSectionHelper.initElsePattern((String)start, (String)end);
        Matcher matcher = pattern.matcher(text);
        StringBuffer result = new StringBuffer();
        int occurences = 0;
        while (matcher.find()) {
            matcher.appendReplacement(result, "FOUND");
            ++occurences;
        }
        matcher.appendTail(result);
        Assert.assertEquals((long)expectedOccurences, (long)occurences);
        Assert.assertEquals((Object)expectedResult, (Object)result.toString());
    }
}

