/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.ArchiveType;
import org.trimou.Hammer;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;

public class SwitchHelperTest
extends AbstractTest {
    @Test
    public void testSwitchHelper() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addGlobalData("type", ArchiveType.class).registerHelpers(HelpersBuilder.empty().addSwitch().build()).build();
        Assert.assertEquals((Object)"WAR", (Object)engine.compileMustache("switch_helper1", "{{#switch this}} {{#case type.WAR break=\"true\"}}WAR{{/case}} {{#case type.EAR}}EAR{{/case}} {{#case type.JAR}}JAR{{/case}} {{#default}}none{{/default}}{{/switch}}").render((Object)new Hammer().getArchiveType()).trim());
        Assert.assertEquals((Object)"baz", (Object)engine.compileMustache("switch_helper2", "{{#switch this}}{{#case \"foo\"}}A{{/case}}{{#case \"bar\"}}B{{/case}}{{#default}}{{this.up}}{{/default}}{{/switch}}").render((Object)"baz").trim());
        Assert.assertEquals((Object)"B", (Object)engine.compileMustache("switch_helper3", "{{#switch this}}{{#case \"foo\"}}A{{/case}}{{#case \"bar\" break=\"true\"}}B{{/case}}{{#default}}C{{/default}}{{/switch}}").render((Object)"bar").trim());
        Assert.assertEquals((Object)"ABC", (Object)engine.compileMustache("switch_helper4", "{{#switch this}}{{#case \"foo\"}}A{{/case}}{{#case \"bar\"}}B{{/case}}{{#default}}C{{/default}}{{/switch}}").render((Object)"foo").trim());
    }

    @Test
    public void testSwitchHelperValidation() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addSwitch().build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(() -> engine.compileMustache("switch_helper_validation01", "{{switch}}")).check(() -> engine.compileMustache("switch_helper_validation02", "{{#switch}}{{case \"true\"}}{{/switch}}")).check(() -> engine.compileMustache("switch_helper_validation03", "{{#switch}}{{#case \"true\"}}{{/case}}{{default \"foo\"}}{{/switch}}"));
    }

    @Test
    public void testSwitchHelperInvalidFlow() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addSet().addSwitch().build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.RENDER_HELPER_INVALID_OPTIONS).check(() -> engine.compileMustache("switch_helper_invalid_flow01", "{{#switch}}{{#set name=\"bar\"}}{{#case \"foo\"}}{{/case}}{{/set}}{{/switch}}").render((Object)"foo"));
    }

    @Test
    public void testSwitchHelperCaseIsBreakByDefault() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addSwitch(true).build()).build();
        Assert.assertEquals((Object)"A", (Object)engine.compileMustache("switch_helper_break_by_default", "{{#switch this}}{{#case \"foo\"}}A{{/case}}{{#case \"bar\"}}B{{/case}}{{#default}}C{{/default}}{{/switch}}").render((Object)"foo").trim());
    }
}

