/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.convert;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.trimou.engine.config.AbstractConfigurationAware;
import org.trimou.engine.convert.ContextConverter;
import org.trimou.engine.resolver.Decorator;
import org.trimou.util.Checker;
import org.trimou.util.ImmutableMap;

public class DecoratorConverter<T>
extends AbstractConfigurationAware
implements ContextConverter {
    private final Predicate<Object> test;
    private final String delegateKey;
    private final Map<String, Function<T, Object>> mappings;

    public static <T> Builder<T> decorate(Class<T> delegateType) {
        return DecoratorConverter.decorate((Object o) -> delegateType.isAssignableFrom(Decorator.unwrap(o).getClass()));
    }

    public static <T> Builder<T> decorate(Predicate<Object> test) {
        return new Builder(test);
    }

    private DecoratorConverter(Predicate<Object> test, String delegateKey, Map<String, Function<T, Object>> mappings) {
        this.test = test;
        this.delegateKey = delegateKey;
        this.mappings = mappings;
    }

    @Override
    public Object convert(Object from) {
        if (this.test.test(from)) {
            return Decorator.decorate(from, this.mappings, this.delegateKey != null ? this.delegateKey.toString() : null, this.configuration);
        }
        return null;
    }

    public static class Builder<T>
    extends Decorator.AbstractBuilder<T, Builder<T>> {
        private final Predicate<Object> test;

        private Builder(Predicate<Object> test) {
            Checker.checkArgumentNotNull(test);
            this.test = test;
        }

        @Override
        protected Builder<T> self() {
            return this;
        }

        public DecoratorConverter<T> build() {
            return new DecoratorConverter(this.test, this.delegateKey, ImmutableMap.copyOf(this.mappings));
        }
    }
}

