/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.resolver.Mapper;
import org.trimou.engine.resolver.ReflectionResolver;
import org.trimou.engine.resolver.Resolver;
import org.trimou.exception.MustacheException;
import org.trimou.util.Checker;
import org.trimou.util.ImmutableMap;

public class Decorator<T>
implements Mapper {
    public static final String KEY_GET_DELEGATE = "delegate";
    private final String delegateKey;
    protected final T delegate;
    private final ReflectionResolver reflectionResolver;
    private final Map<String, Function<T, Object>> mappings;

    public static <T> Builder<T> decorate(T delegate) {
        return new Builder(delegate);
    }

    public static <T> Decorator<T> decorate(T delegate, Map<String, Function<T, Object>> mappings, String delegateKey, Configuration configuration) {
        return IterableDecorator.isIterable(delegate) ? new IterableDecorator(delegate, ImmutableMap.copyOf(mappings), delegateKey, configuration) : new Decorator<T>(delegate, ImmutableMap.copyOf(mappings), delegateKey, configuration);
    }

    public static <T> T unwrap(T instance) {
        return instance instanceof Decorator ? Decorator.unwrap(((Decorator)instance).delegate) : instance;
    }

    private Decorator(T delegate, Map<String, Function<T, Object>> mappings, String delegateKey, Configuration configuration) {
        this.delegate = delegate;
        this.reflectionResolver = this.getReflectionResolver(configuration);
        this.mappings = mappings;
        this.delegateKey = delegateKey != null ? delegateKey : KEY_GET_DELEGATE;
    }

    @Override
    public Object get(String key) {
        if (this.delegateKey.equals(key)) {
            return this.delegate;
        }
        Function<T, Object> mapping = this.mappings.get(key);
        if (mapping != null) {
            return mapping.apply(Decorator.unwrap(this.delegate));
        }
        if (this.delegate instanceof Mapper) {
            return ((Mapper)this.delegate).get(key);
        }
        return this.reflectionResolver.resolve(this.delegate, key, null);
    }

    public String toString() {
        return this.delegate.toString();
    }

    private ReflectionResolver getReflectionResolver(Configuration configuration) {
        for (Resolver resolver : configuration.getResolvers()) {
            if (!(resolver instanceof ReflectionResolver)) continue;
            return (ReflectionResolver)resolver;
        }
        throw new IllegalStateException("Decorator can only be used if ReflectionResolver is available");
    }

    public static abstract class AbstractBuilder<T, B extends AbstractBuilder<T, B>> {
        protected String delegateKey;
        protected final Map<String, Function<T, Object>> mappings = new HashMap<String, Function<T, Object>>();

        public B put(String key, Object value) {
            return this.compute(key, delegate -> value);
        }

        public B compute(String key, Function<T, Object> mapper) {
            Checker.checkArgumentsNotNull(key, mapper);
            this.mappings.put(key, mapper);
            return this.self();
        }

        public B delegateKey(String key) {
            this.delegateKey = key;
            return this.self();
        }

        protected abstract B self();
    }

    private static class IterableDecorator<T>
    extends Decorator<T>
    implements Iterable<Object> {
        static boolean isIterable(Object delegate) {
            return delegate instanceof Iterable || delegate.getClass().isArray() || delegate instanceof Iterator || delegate instanceof Spliterator || delegate instanceof Stream;
        }

        private IterableDecorator(T delegate, Map<String, Function<T, Object>> mappings, String delegateKey, Configuration configuration) {
            super(delegate, mappings, delegateKey, configuration);
        }

        @Override
        public Iterator<Object> iterator() {
            if (this.delegate instanceof Iterable) {
                return ((Iterable)this.delegate).iterator();
            }
            if (this.delegate.getClass().isArray()) {
                int length = Array.getLength(this.delegate);
                ArrayList<Object> elements = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    elements.add(Array.get(this.delegate, i));
                }
                return elements.iterator();
            }
            if (this.delegate instanceof Iterator) {
                return (Iterator)this.delegate;
            }
            if (this.delegate instanceof Spliterator) {
                return Spliterators.iterator((Spliterator)this.delegate);
            }
            if (this.delegate instanceof Stream) {
                return ((Stream)this.delegate).sequential().iterator();
            }
            throw new MustacheException(this.delegate + "is not iterable");
        }
    }

    public static class Builder<T>
    extends AbstractBuilder<T, Builder<T>> {
        private final T delegate;

        private Builder(T delegate) {
            Checker.checkArgumentNotNull(delegate);
            this.delegate = delegate;
        }

        @Override
        protected Builder<T> self() {
            return this;
        }

        public Decorator<T> build(MustacheEngine engine) {
            return this.build(engine.getConfiguration());
        }

        public Decorator<T> build(Configuration configuration) {
            Checker.checkArgumentNotNull(configuration);
            return Decorator.decorate(this.delegate, ImmutableMap.copyOf(this.mappings), this.delegateKey, configuration);
        }
    }
}

