/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver.i18n;

import java.text.NumberFormat;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.CombinedIndexResolver;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.TransformResolver;

public class NumberFormatResolver
extends TransformResolver {
    public static final int NUMBER_FORMAT_RESOLVER_PRIORITY = Priorities.rightAfter(CombinedIndexResolver.INDEX_RESOLVER_PRIORITY);
    static final String NAME_FORMAT = "format";
    static final String NAME_FORMAT_PERCENT = "formatPercent";
    static final String NAME_FORMAT_CURR = "formatCurrency";

    public NumberFormatResolver() {
        this(NUMBER_FORMAT_RESOLVER_PRIORITY);
    }

    public NumberFormatResolver(int priority) {
        super(priority, NAME_FORMAT, NAME_FORMAT_CURR, NAME_FORMAT_PERCENT);
    }

    @Override
    protected boolean matches(Object contextObject, String name) {
        return super.matches(contextObject, name) && contextObject instanceof Number;
    }

    @Override
    public Object transform(Object contextObject, String name, ResolutionContext context) {
        if (NAME_FORMAT.equals(name)) {
            return NumberFormat.getNumberInstance(this.getCurrentLocale()).format(contextObject);
        }
        if (NAME_FORMAT_PERCENT.equals(name)) {
            return NumberFormat.getPercentInstance(this.getCurrentLocale()).format(contextObject);
        }
        if (NAME_FORMAT_CURR.equals(name)) {
            return NumberFormat.getCurrencyInstance(this.getCurrentLocale()).format(contextObject);
        }
        return null;
    }
}

