/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.util;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.trimou.annotations.Internal;
import org.trimou.exception.MustacheException;
import org.trimou.exception.MustacheProblem;
import org.trimou.util.Checker;

@Internal
public class Escaper {
    private final Map<Character, String> replacements;

    private Escaper(Map<Character, String> replacements) {
        this.replacements = replacements.isEmpty() ? Collections.emptyMap() : new HashMap<Character, String>(replacements);
    }

    public String escape(String value) {
        Checker.checkArgumentNotNull(value);
        if (value.isEmpty()) {
            return value;
        }
        for (int i = 0; i < value.length(); ++i) {
            String replacement = this.replacements.get(Character.valueOf(value.charAt(i)));
            if (replacement == null) continue;
            StringBuilder result = new StringBuilder();
            result.append(value.substring(0, i));
            result.append(replacement);
            try {
                this.escapeNext(value, i, result);
            }
            catch (IOException e) {
                throw new MustacheException(MustacheProblem.RENDER_IO_ERROR, (Throwable)e);
            }
            return result.toString();
        }
        return value;
    }

    public void escape(String value, Appendable appendable) throws IOException {
        Checker.checkArgumentsNotNull(value, appendable);
        if (value.isEmpty()) {
            return;
        }
        for (int i = 0; i < value.length(); ++i) {
            String replacement = this.replacements.get(Character.valueOf(value.charAt(i)));
            if (replacement == null) continue;
            appendable.append(value.substring(0, i));
            appendable.append(replacement);
            this.escapeNext(value, i, appendable);
            return;
        }
        appendable.append(value);
    }

    private void escapeNext(String value, int index, Appendable appendable) throws IOException {
        int length = value.length();
        while (++index < length) {
            char c = value.charAt(index);
            String replacement = this.replacements.get(Character.valueOf(c));
            if (replacement != null) {
                appendable.append(replacement);
                continue;
            }
            appendable.append(c);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Character, String> replacements = new HashMap<Character, String>();

        private Builder() {
        }

        public Builder add(char c, String replacement) {
            this.replacements.put(Character.valueOf(c), replacement);
            return this;
        }

        public Escaper build() {
            return new Escaper(this.replacements);
        }
    }
}

