/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.Hammer;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.cache.ComputingCache;
import org.trimou.engine.cache.ComputingCacheFactory;
import org.trimou.engine.config.AbstractConfigurationAware;
import org.trimou.engine.locator.MapTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.resolver.ReflectionResolver;
import org.trimou.engine.resolver.Resolver;
import org.trimou.util.ImmutableMap;

public class CustomComputingCacheFactoryTest
extends AbstractTest {
    @Test
    public void testCustomFactory() {
        CustomFactory factory = new CustomFactory();
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addTemplateLocator((TemplateLocator)new MapTemplateLocator(ImmutableMap.of((Object)"foo", (Object)"{{this.age}}"))).setComputingCacheFactory((ComputingCacheFactory)factory).build();
        Assert.assertEquals((Object)"10", (Object)engine.getMustache("foo").render((Object)new Hammer()));
        List<CustomComputingCache> reflectionCaches = factory.caches.get(ReflectionResolver.COMPUTING_CACHE_CONSUMER_ID);
        Assert.assertEquals((long)1L, (long)reflectionCaches.size());
        CustomComputingCache reflectionCache = reflectionCaches.get(0);
        Assert.assertEquals((long)1L, (long)reflectionCache.size());
        List<CustomComputingCache> templateCaches = factory.caches.get(MustacheEngine.COMPUTING_CACHE_CONSUMER_ID);
        Assert.assertEquals((long)1L, (long)templateCaches.size());
        for (CustomComputingCache cache : templateCaches) {
            cache.clear();
        }
        this.getReflectionResolver(engine).invalidateMemberCache(null);
        Assert.assertEquals((long)0L, (long)reflectionCache.size());
        Assert.assertEquals((Object)"10", (Object)engine.getMustache("foo").render((Object)new Hammer()));
    }

    private ReflectionResolver getReflectionResolver(MustacheEngine engine) {
        for (Resolver resolver : engine.getConfiguration().getResolvers()) {
            if (!(resolver instanceof ReflectionResolver)) continue;
            return (ReflectionResolver)resolver;
        }
        return null;
    }

    private static class CustomComputingCache<K, V>
    implements ComputingCache<K, V> {
        final Map<K, V> map;
        final ComputingCache.Function<K, V> computingFunction;

        public CustomComputingCache(Map<K, V> map, ComputingCache.Function<K, V> computingFunction) {
            this.map = map;
            this.computingFunction = computingFunction;
        }

        public synchronized V get(K key) {
            return (V)this.map.computeIfAbsent(key, k -> this.computingFunction.compute(key));
        }

        public synchronized void clear() {
            this.map.clear();
        }

        public synchronized long size() {
            return this.map.size();
        }

        public synchronized void invalidate(ComputingCache.KeyPredicate<K> keyPredicate) {
            this.map.entrySet().removeIf(entry -> keyPredicate.apply(entry.getKey()));
        }

        public synchronized V getIfPresent(K key) {
            return this.map.get(key);
        }

        public synchronized Map<K, V> getAllPresent() {
            return ImmutableMap.copyOf(this.map);
        }
    }

    private static class CustomFactory
    extends AbstractConfigurationAware
    implements ComputingCacheFactory {
        final Map<String, List<CustomComputingCache>> caches = new HashMap<String, List<CustomComputingCache>>();

        private CustomFactory() {
        }

        public <K, V> ComputingCache<K, V> create(String consumerId, ComputingCache.Function<K, V> computingFunction, Long expirationTimeout, Long maxSize, ComputingCache.Listener<K> listener) {
            CustomComputingCache cache = new CustomComputingCache(new HashMap(), computingFunction);
            List list = this.caches.computeIfAbsent(consumerId, k -> new ArrayList());
            list.add(cache);
            return cache;
        }
    }
}

