/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.convert;

import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.convert.ContextConverter;

public class ContextConverterTest
extends AbstractTest {
    @Test
    public void testContextConverter() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addContextConverter(v -> v instanceof String ? Integer.valueOf(v.toString().length()) : null).build();
        Mustache mustache = engine.compileMustache("{{this}}");
        Assert.assertEquals((Object)"3", (Object)mustache.render((Object)"Foo"));
        Assert.assertEquals((Object)"1", (Object)mustache.render((Object)1));
    }

    @Test
    public void testInvalidContextConverter() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addContextConverter(new ContextConverter(){

            public Object convert(Object from) {
                return "true";
            }

            public boolean isValid() {
                return false;
            }
        }).build();
        Assert.assertEquals((Object)"Foo", (Object)engine.compileMustache("{{this}}").render((Object)"Foo"));
    }

    @Test
    public void testContextConverterOrdering() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addContextConverter(new ContextConverter(){

            public Object convert(Object from) {
                return from.toString().toUpperCase();
            }

            public int getPriority() {
                return 1;
            }

            public String toString() {
                return "P1";
            }
        }).addContextConverter(new ContextConverter(){

            public Object convert(Object from) {
                return from.toString().toLowerCase();
            }

            public int getPriority() {
                return 2;
            }

            public String toString() {
                return "P2";
            }
        }).build();
        Assert.assertEquals((Object)"foo", (Object)engine.compileMustache("{{this}}").render((Object)"Foo"));
    }
}

