/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.Hammer;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.convert.ContextConverter;
import org.trimou.engine.convert.DecoratorConverter;
import org.trimou.engine.resolver.Decorator;
import org.trimou.util.ImmutableList;

public class DecoratorConverterTest
extends AbstractTest {
    @Test
    public void testInterpolation() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addContextConverter((ContextConverter)((DecoratorConverter.Builder)DecoratorConverter.decorate(String.class).compute("reverse", string -> new StringBuilder((String)string).reverse().toString())).build()).addContextConverter((ContextConverter)((DecoratorConverter.Builder)((DecoratorConverter.Builder)DecoratorConverter.decorate(Hammer.class).put("translate", (Object)"kladivo")).compute("name", hammer -> hammer.getName().toUpperCase())).build()).addContextConverter((ContextConverter)((DecoratorConverter.Builder)DecoratorConverter.decorate(List.class).compute("reversed", list -> {
            ArrayList reversed = new ArrayList(list);
            Collections.reverse(reversed);
            return reversed;
        })).build()).build();
        Assert.assertEquals((Object)"ooF", (Object)engine.compileMustache("{{reverse}}").render((Object)"Foo"));
        Assert.assertEquals((Object)"kladivo EDGAR 10", (Object)engine.compileMustache("{{translate}} {{name}} {{age}}").render((Object)new Hammer()));
        Assert.assertEquals((Object)"bravo:charlie:alpha:", (Object)engine.compileMustache("{{#each this.reversed}}{{.}}:{{/each}}").render((Object)ImmutableList.of((Object[])new String[]{"alpha", "charlie", "bravo"})));
        Assert.assertEquals((Object)"EDGAR 1000", (Object)engine.compileMustache("{{name}} {{age}}").render((Object)((Decorator.Builder)Decorator.decorate((Object)new Hammer()).put("age", (Object)1000)).build(engine)));
    }

    @Test
    public void testGetDelegate() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().addContextConverter((ContextConverter)((DecoratorConverter.Builder)DecoratorConverter.decorate(Hammer.class).compute("name", h -> h.getName().toUpperCase())).build()).build();
        Hammer hammer = new Hammer();
        Assert.assertEquals((Object)"EDGAR vs Edgar", (Object)engine.compileMustache("{{name}} vs {{delegate.name}}").render((Object)hammer));
    }
}

