/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.ArchiveType;
import org.trimou.Hammer;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.resolver.CombinedIndexResolver;
import org.trimou.engine.resolver.ReflectionResolver;
import org.trimou.engine.resolver.ResolutionContext;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.resolver.ThisResolver;
import org.trimou.util.ImmutableList;
import org.trimou.util.ImmutableMap;

public class ReflectionResolverTest
extends AbstractEngineTest {
    @Test
    public void testResolution() {
        ReflectionResolver resolver = new ReflectionResolver();
        MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)resolver).build();
        Hammer hammer = new Hammer();
        Assert.assertNull((Object)resolver.resolve(null, "whatever", null));
        Assert.assertNotNull((Object)resolver.resolve((Object)hammer, "age", null));
        Assert.assertEquals((Object)10, (Object)resolver.resolve((Object)hammer, "age", null));
        Assert.assertNull((Object)resolver.resolve((Object)hammer, "getAgeForName", null));
    }

    @Test
    public void testInterpolation() {
        int[] array = new int[]{1, 2};
        Map data = ImmutableMap.of((Object)"hammer", (Object)new Hammer(), (Object)"type", ArchiveType.class, (Object)"array", (Object)array);
        Assert.assertEquals((Object)"Hello Edgar of age 10, persistent: false and !", (Object)this.engine.compileMustache("reflection_resolver", "Hello {{hammer.name}} of age {{hammer.age}}, persistent: {{hammer.persistent}} and {{hammer.invalidName}}!").render((Object)data));
        Assert.assertEquals((Object)"NAIL|jar", (Object)this.engine.compileMustache("reflection_resolver_fields", "{{hammer.nail}}|{{type.JAR.suffix}}").render((Object)data));
        Assert.assertEquals((Object)"jar,war,ear,", (Object)this.engine.compileMustache("reflection_resolver_static_method", "{{#type.values}}{{this.suffix}},{{/type.values}}").render((Object)data));
        Assert.assertEquals((Object)("" + array.length), (Object)this.engine.compileMustache("reflection_resolver_array", "{{array.length}}").render((Object)data));
    }

    @Test
    public void testPublicMethodOnPackagePrivateClass() {
        Hammer data = new Hammer();
        Mustache mustache = this.engine.compileMustache("reflection_resolver_accessibility", "{{#this.map.entrySet}}{{key}}={{value}}{{/this.map.entrySet}}");
        Assert.assertEquals((Object)"foo=10", (Object)mustache.render((Object)data));
        Assert.assertEquals((Object)"foo=10", (Object)mustache.render((Object)data));
    }

    @Test
    public void testMemberCacheInvalidation() {
        ReflectionResolver resolver = new ReflectionResolver();
        MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)resolver).build();
        Hammer hammer = new Hammer();
        Assert.assertNotNull((Object)resolver.resolve((Object)hammer, "age", null));
        resolver.invalidateMemberCache(null);
        Assert.assertEquals((long)0L, (long)resolver.getMemberCacheSize());
        Assert.assertNotNull((Object)resolver.resolve((Object)hammer, "age", null));
        Assert.assertNotNull((Object)resolver.resolve(ArchiveType.class, "JAR", null));
        resolver.invalidateMemberCache(input -> input.getName().equals(ArchiveType.class.getName()));
        Assert.assertEquals((long)1L, (long)resolver.getMemberCacheSize());
    }

    @Test(expected=IllegalStateException.class)
    public void testMultipleInit() {
        ReflectionResolver resolver = new ReflectionResolver();
        MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)resolver).build();
        resolver.init(null);
    }

    @Test
    public void testGetMembers() {
        Assert.assertNotNull((Object)ReflectionResolver.findMethod(Charlie.class, (String)"name"));
        Assert.assertNotNull((Object)ReflectionResolver.findMethod(Charlie.class, (String)"old"));
        Assert.assertNotNull((Object)ReflectionResolver.findMethod(Charlie.class, (String)"hasSomething"));
        Assert.assertNotNull((Object)ReflectionResolver.findMethod(Charlie.class, (String)"getAnotherName"));
        Assert.assertNotNull((Object)ReflectionResolver.findMethod(Charlie.class, (String)"anotherName"));
        Assert.assertNotNull((Object)ReflectionResolver.findMethod(Charlie.class, (String)"isOk"));
        Assert.assertNotNull((Object)ReflectionResolver.findMethod(Charlie.class, (String)"ok"));
        Assert.assertNotNull((Object)ReflectionResolver.findMethod(Charlie.class, (String)"info"));
        Assert.assertNull((Object)ReflectionResolver.findMethod(Charlie.class, (String)"getPrice"));
        Assert.assertNotNull((Object)ReflectionResolver.findField(Charlie.class, (String)"publicField"));
        Assert.assertNull((Object)ReflectionResolver.findField(Charlie.class, (String)"privateField"));
    }

    @Test
    public void testGetSimpleName() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)new ReflectionResolver()).addResolver((Resolver)new ThisResolver()).addResolver((Resolver)new CombinedIndexResolver()).build();
        Assert.assertEquals((Object)(Integer.class.getSimpleName() + ":" + ArchiveType.class.getSimpleName()), (Object)engine.compileMustache("testTemplate", "{{this.0.simpleName}}:{{this.1.simpleName}}").render((Object)ImmutableList.of((Object[])new Class[]{Integer.class, ArchiveType.class})));
    }

    @Test
    public void testHintFallbackDisabled() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver(new Resolver(){

            public Object resolve(Object contextObject, String name, ResolutionContext context) {
                if (contextObject instanceof Set && name.equals("size")) {
                    return 1;
                }
                return null;
            }

            public int getPriority() {
                return ReflectionResolver.REFLECTION_RESOLVER_PRIORITY + 1;
            }
        }).addResolver((Resolver)new ReflectionResolver()).setProperty(ReflectionResolver.HINT_FALLBACK_ENABLED_KEY, (Object)false).build();
        Mustache mustache = engine.compileMustache("{{size}}");
        Assert.assertEquals((Object)"0", (Object)mustache.render(new ArrayList()));
        Assert.assertEquals((Object)"1", (Object)mustache.render(new HashSet()));
    }

    public static class Charlie
    extends Bravo {
        public Boolean isOk() {
            return null;
        }
    }

    public static class Bravo
    extends Alpha {
        public final String publicField = "foo";

        public String getWithParam(String param) {
            return null;
        }

        public void getNoReturnValue() {
        }

        public String getAnotherName() {
            return null;
        }
    }

    public static class Alpha {
        private String privateField;

        public String getName() {
            return null;
        }

        public int isOld() {
            return 1;
        }

        public boolean hasSomething() {
            return true;
        }

        private BigDecimal getPrice() {
            return null;
        }

        public String getInfo() {
            return null;
        }

        protected String getProtected() {
            return null;
        }
    }
}

