/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.engine.resolver.i18n;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.trimou.AbstractEngineTest;
import org.trimou.Mustache;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.locale.FixedLocaleSupport;
import org.trimou.engine.locale.LocaleSupport;
import org.trimou.engine.resolver.Resolver;
import org.trimou.engine.resolver.i18n.NumberFormatResolver;
import org.trimou.util.ImmutableMap;

public class NumberFormatResolverTest
extends AbstractEngineTest {
    private NumberFormatResolver resolver;

    @Override
    @Before
    public void buildEngine() {
        this.resolver = new NumberFormatResolver();
        this.engine = MustacheEngineBuilder.newBuilder().setLocaleSupport((LocaleSupport)FixedLocaleSupport.from((Locale)new Locale("cs", "CZ"))).addResolver((Resolver)this.resolver).build();
    }

    @Test
    public void testResolution() {
        Assert.assertNull((Object)this.resolver.resolve((Object)new Date(), "foo", null));
        Assert.assertNull((Object)this.resolver.resolve((Object)5, "foo", null));
        Assert.assertNotNull((Object)this.resolver.resolve((Object)5, "format", null));
    }

    @Test
    public void testInterpolation() {
        String templateContents = "{{number.format}}|{{number.formatPercent}}|{{number.formatCurrency}}";
        Mustache mustache = this.engine.compileMustache("number", templateContents);
        Assert.assertEquals((Object)"1,5|150%|1,5 K\u010d", (Object)mustache.render((Object)ImmutableMap.of((Object)"number", (Object)new BigDecimal("1.5"))));
    }

    @Test(expected=IllegalStateException.class)
    public void testMultipleInit() {
        NumberFormatResolver resolver = new NumberFormatResolver();
        MustacheEngineBuilder.newBuilder().omitServiceLoaderConfigurationExtensions().addResolver((Resolver)resolver).build();
        resolver.init(null);
    }
}

