/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.trimou.AbstractTest;
import org.trimou.MustacheExceptionAssert;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.MustacheTagInfo;
import org.trimou.engine.interpolation.MissingValueHandler;
import org.trimou.engine.interpolation.NoOpMissingValueHandler;
import org.trimou.exception.MustacheProblem;
import org.trimou.exception.ProblemCode;
import org.trimou.handlebars.HelpersBuilder;

public class AlternativesHelperTest
extends AbstractTest {
    @Test
    public void testInterpolation() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addAlt().addMin().addMax().build()).setMissingValueHandler((MissingValueHandler)new NoOpMissingValueHandler(){

            public Object handle(MustacheTagInfo tagInfo) {
                return "---";
            }
        }).build();
        Assert.assertEquals((Object)"Joe", (Object)engine.compileMustache("alt_helper01", "{{alt name 'Joe'}}").render(null));
        Assert.assertEquals((Object)"Ed", (Object)engine.compileMustache("alt_helper02", "{{alt this 'Joe'}}").render((Object)"Ed"));
        Assert.assertEquals((Object)"---", (Object)engine.compileMustache("alt_helper03", "{{alt this}}").render(null));
        Assert.assertEquals((Object)"Joe", (Object)engine.compileMustache("alt_helper04", "{{alt 'Joe' this}}").render((Object)"Ed"));
        Assert.assertEquals((Object)"Ed", (Object)engine.compileMustache("alt_helper05", "{{alt '' this}}").render((Object)"Ed"));
        Assert.assertEquals((Object)"0", (Object)engine.compileMustache("min_helper01", "{{min '1' 10 30l this}}").render((Object)BigDecimal.ZERO));
        Assert.assertEquals((Object)"30", (Object)engine.compileMustache("max_helper01", "{{max 1 10 30l this}}").render((Object)BigDecimal.ZERO));
        Assert.assertEquals((Object)"Me", (Object)engine.compileMustache("alt_helper01", "{{#alt 'Me' 'Joe'}}{{this}}{{/alt}}").render(null));
    }

    @Test
    public void testValidation() {
        MustacheEngine engine = MustacheEngineBuilder.newBuilder().registerHelpers(HelpersBuilder.empty().addAlt().build()).build();
        MustacheExceptionAssert.expect((ProblemCode)MustacheProblem.COMPILE_HELPER_VALIDATION_FAILURE).check(() -> engine.compileMustache("alt_helper_validation01", "{{#alt}}{{/alt}}")).check(() -> engine.compileMustache("alt_helper_validation02", "{{alt}}"));
    }
}

