/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.handlebars;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.trimou.engine.resolver.Decorator;
import org.trimou.handlebars.BasicSectionHelper;
import org.trimou.handlebars.Options;
import org.trimou.util.Checker;
import org.trimou.util.ImmutableMap;

public class DecoratorHelper<T>
extends BasicSectionHelper {
    private final String delegateKey;
    private final Predicate<Object> test;
    private final Map<String, Function<T, Object>> mappings;

    public static <T> Builder<T> decorate(Class<T> delegateType) {
        return new Builder(o -> delegateType.isAssignableFrom(o.getClass()));
    }

    public static <T> Builder<T> decorate(Predicate<Object> test) {
        return new Builder(test);
    }

    private DecoratorHelper(Predicate<Object> test, Map<String, Function<T, Object>> mappings, String delegateKey) {
        this.test = test;
        this.mappings = mappings;
        this.delegateKey = delegateKey;
    }

    @Override
    public void execute(Options options) {
        Object param;
        Object object = param = options.getParameters().size() == 1 ? options.getParameters().get(0) : options.peek();
        if (param == null) {
            return;
        }
        if (!this.test.test(param)) {
            throw new IllegalStateException("Param " + param.getClass() + " is not applicable: " + options.getTagInfo());
        }
        options.push(Decorator.decorate(param, this.mappings, this.delegateKey != null ? this.delegateKey.toString() : null, this.configuration));
        options.fn();
        options.pop();
    }

    @Override
    protected int numberOfRequiredParameters() {
        return 0;
    }

    public static class Builder<T>
    extends Decorator.AbstractBuilder<T, Builder<T>> {
        private final Predicate<Object> test;

        private Builder(Predicate<Object> test) {
            Checker.checkArgumentNotNull(test);
            this.test = test;
        }

        @Override
        protected Builder<T> self() {
            return this;
        }

        public DecoratorHelper<T> build() {
            return new DecoratorHelper(this.test, ImmutableMap.copyOf(this.mappings), this.delegateKey);
        }
    }
}

