/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.el;

import javax.el.ELProcessor;
import org.trimou.el.SecurityActions;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;

@FunctionalInterface
public interface ELProcessorFactory {
    public static final ConfigurationKey EL_PROCESSOR_FACTORY_KEY = new SimpleConfigurationKey(ELProcessorFactory.class.getName(), (Object)ELProcessorFactory.defaultFactory(), ELProcessorFactory::convert);

    public ELProcessor createELProcessor(Configuration var1);

    public static ELProcessorFactory defaultFactory() {
        return c -> new ELProcessor();
    }

    public static Object convert(Object value) {
        if (value instanceof ELProcessorFactory) {
            return value;
        }
        if (value instanceof String) {
            String clazz = value.toString();
            if (clazz.isEmpty()) {
                return null;
            }
            ClassLoader cl = SecurityActions.getContextClassLoader();
            if (cl == null) {
                cl = SecurityActions.getClassLoader(ELProcessorFactory.class);
            }
            try {
                return cl.loadClass(clazz).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("ELProcessorFactory cannot be instantiated: " + value, e);
            }
        }
        throw new IllegalStateException("Unsupported value type: " + value);
    }
}

