/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.gson.resolver;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.Set;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.ArrayIndexResolver;
import org.trimou.engine.resolver.IndexResolver;
import org.trimou.engine.resolver.ResolutionContext;

public class JsonElementResolver
extends IndexResolver {
    public static final int JSON_ELEMENT_RESOLVER_PRIORITY = Priorities.rightAfter((int)ArrayIndexResolver.ARRAY_RESOLVER_PRIORITY);
    public static final ConfigurationKey UNWRAP_JSON_PRIMITIVE_KEY = new SimpleConfigurationKey(JsonElementResolver.class.getName() + ".unwrapJsonPrimitive", (Object)true);
    private boolean unwrapJsonPrimitive;

    public JsonElementResolver() {
        this(JSON_ELEMENT_RESOLVER_PRIORITY);
    }

    public JsonElementResolver(int priority) {
        super(priority);
    }

    public Object resolve(Object contextObject, String name, ResolutionContext context) {
        if (contextObject == null || !(contextObject instanceof JsonElement)) {
            return null;
        }
        JsonElement element = (JsonElement)contextObject;
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonArray() && this.isAnIndex(name)) {
            JsonArray jsonArray = (JsonArray)element;
            return jsonArray.get(this.getIndexValue(name, jsonArray.size()).intValue());
        }
        if (element.isJsonObject()) {
            JsonObject jsonObject = (JsonObject)element;
            JsonElement member = jsonObject.get(name);
            if (member != null) {
                if (member.isJsonPrimitive() && this.unwrapJsonPrimitive) {
                    return this.unwrapJsonPrimitive((JsonPrimitive)member);
                }
                return member;
            }
        } else if (element.isJsonPrimitive() && this.unwrapJsonPrimitive) {
            return this.unwrapJsonPrimitive((JsonPrimitive)element);
        }
        return null;
    }

    private Object unwrapJsonPrimitive(JsonPrimitive jsonPrimitive) {
        if (jsonPrimitive.isBoolean()) {
            return jsonPrimitive.getAsBoolean();
        }
        if (jsonPrimitive.isString()) {
            return jsonPrimitive.getAsString();
        }
        if (jsonPrimitive.isNumber()) {
            return jsonPrimitive.getAsNumber();
        }
        return null;
    }

    public void init(Configuration configuration) {
        this.unwrapJsonPrimitive = configuration.getBooleanPropertyValue(UNWRAP_JSON_PRIMITIVE_KEY);
    }

    public Set<ConfigurationKey> getConfigurationKeys() {
        return Collections.singleton(UNWRAP_JSON_PRIMITIVE_KEY);
    }
}

