/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.gson.resolver;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.Set;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.engine.priority.Priorities;
import org.trimou.engine.resolver.EnhancedResolver;
import org.trimou.engine.resolver.IndexResolver;
import org.trimou.engine.resolver.MapResolver;
import org.trimou.engine.resolver.Placeholder;
import org.trimou.engine.resolver.ResolutionContext;

public class JsonElementResolver
extends IndexResolver {
    public static final int JSON_ELEMENT_RESOLVER_PRIORITY = Priorities.rightBefore((int)MapResolver.MAP_RESOLVER_PRIORITY);
    public static final String NAME_UNWRAP_THIS = "unwrapThis";
    public static final ConfigurationKey UNWRAP_JSON_PRIMITIVE_KEY = new SimpleConfigurationKey(JsonElementResolver.class.getName() + ".unwrapJsonPrimitive", (Object)true);
    private boolean unwrapJsonPrimitive;
    private final EnhancedResolver.Hint hint = new EnhancedResolver.Hint(){

        public Object resolve(Object contextObject, String name, ResolutionContext context) {
            return JsonElementResolver.this.resolve(contextObject, name, context);
        }
    };

    public JsonElementResolver() {
        this(JSON_ELEMENT_RESOLVER_PRIORITY);
    }

    public JsonElementResolver(int priority) {
        super(priority);
    }

    public Object resolve(Object contextObject, String name, ResolutionContext context) {
        if (contextObject == null || !(contextObject instanceof JsonElement)) {
            return null;
        }
        JsonElement element = (JsonElement)contextObject;
        if (element.isJsonArray() && this.isAnIndex(name)) {
            JsonArray jsonArray = (JsonArray)element;
            Integer index = this.getIndexValue(name, context.getKey(), jsonArray.size());
            if (index != null) {
                return this.unwrapJsonElementIfNecessary(jsonArray.get(index.intValue()));
            }
        } else if (element.isJsonObject()) {
            JsonObject jsonObject = (JsonObject)element;
            JsonElement member = jsonObject.get(name);
            if (member != null) {
                return this.unwrapJsonElementIfNecessary(member);
            }
        } else if (name.equals(NAME_UNWRAP_THIS)) {
            return this.unwrapJsonElementIfNecessary(element);
        }
        return null;
    }

    public void init() {
        this.unwrapJsonPrimitive = this.configuration.getBooleanPropertyValue(UNWRAP_JSON_PRIMITIVE_KEY);
    }

    public Set<ConfigurationKey> getConfigurationKeys() {
        return Collections.singleton(UNWRAP_JSON_PRIMITIVE_KEY);
    }

    public EnhancedResolver.Hint createHint(Object contextObject, String name, ResolutionContext context) {
        return this.hint;
    }

    private Object unwrapJsonElementIfNecessary(JsonElement jsonElement) {
        if (this.unwrapJsonPrimitive) {
            if (jsonElement.isJsonPrimitive()) {
                return this.unwrapJsonPrimitive((JsonPrimitive)jsonElement);
            }
            if (jsonElement.isJsonNull()) {
                return Placeholder.NULL;
            }
        }
        return jsonElement;
    }

    private Object unwrapJsonPrimitive(JsonPrimitive jsonPrimitive) {
        if (jsonPrimitive.isBoolean()) {
            return jsonPrimitive.getAsBoolean();
        }
        if (jsonPrimitive.isString()) {
            return jsonPrimitive.getAsString();
        }
        if (jsonPrimitive.isNumber()) {
            return jsonPrimitive.getAsNumber();
        }
        return jsonPrimitive;
    }
}

