/*
 * Decompiled with CFR 0.152.
 */
package org.trimou.gson.converter;

import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.Set;
import org.trimou.engine.config.Configuration;
import org.trimou.engine.config.ConfigurationKey;
import org.trimou.engine.config.SimpleConfigurationKey;
import org.trimou.engine.convert.AbstractValueConverter;

public class GsonValueConverter
extends AbstractValueConverter {
    public static final ConfigurationKey ENABLED_KEY = new SimpleConfigurationKey(GsonValueConverter.class.getName() + ".enabled", (Object)true);

    public GsonValueConverter() {
    }

    public GsonValueConverter(int priority) {
        super(priority);
    }

    public String convert(Object value) {
        if (value instanceof JsonPrimitive) {
            return ((JsonPrimitive)value).getAsString();
        }
        if (value instanceof JsonNull) {
            return "";
        }
        return null;
    }

    public void init(Configuration configuration) {
        this.isEnabled = configuration.getBooleanPropertyValue(ENABLED_KEY);
    }

    public Set<ConfigurationKey> getConfigurationKeys() {
        return Collections.singleton(ENABLED_KEY);
    }
}

