/*
 * Decompiled with CFR 0.152.
 */
package org.tsers.zeison;

import java.io.Serializable;
import org.tsers.zeison.Zeison;
import org.tsers.zeison.Zeison$JNull$;
import org.tsers.zeison.Zeison$JUndefined$;
import org.tsers.zeison.Zeison$ZeisonException$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Rendering$ {
    public static final Rendering$ MODULE$ = new Rendering$();
    private static final String Hex = "0123456789ABCDEF".intern();

    private final String Hex() {
        return Hex;
    }

    private final int IndentWidth() {
        return 2;
    }

    public String render(Zeison.JValue value, boolean pretty) {
        StringBuilder sb = new StringBuilder();
        this.org$tsers$zeison$Rendering$$renderRecursive(value, sb, pretty, 0);
        return sb.toString();
    }

    public void org$tsers$zeison$Rendering$$renderRecursive(Zeison.JValue value, StringBuilder sb, boolean pretty, int indent) {
        Zeison.JValue jValue = value;
        if (Zeison$JUndefined$.MODULE$.equals(jValue)) {
            throw new Zeison.ZeisonException("Can't render JUndefined", Zeison$ZeisonException$.MODULE$.$lessinit$greater$default$2());
        }
        if (Zeison$JNull$.MODULE$.equals(jValue)) {
            sb.append("null");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof Zeison.JBoolean) {
            Zeison.JBoolean jBoolean = (Zeison.JBoolean)jValue;
            boolean v = jBoolean.value();
            sb.append(v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof Zeison.JNum) {
            Zeison.JNum jNum = (Zeison.JNum)jValue;
            sb.append(jNum.valueAsString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof Zeison.JString) {
            Zeison.JString jString = (Zeison.JString)jValue;
            String v = jString.value();
            Rendering$.renderStr$1(v, sb);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jValue instanceof Zeison.JObject) {
            BoxedUnit boxedUnit;
            Zeison.JObject jObject = (Zeison.JObject)jValue;
            Map<String, Zeison.JValue> fields = jObject.fields();
            if (pretty) {
                Rendering$.prettyObject$1(fields, sb, indent);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Rendering$.compactObject$1(fields, sb);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (jValue instanceof Zeison.JArray) {
            BoxedUnit boxedUnit;
            Zeison.JArray jArray = (Zeison.JArray)jValue;
            Vector<Zeison.JValue> elems = jArray.elems();
            if (pretty) {
                this.prettyArray$1(elems, sb, indent);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Rendering$.compactArray$1(elems, sb);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (jValue instanceof Zeison.JCustom) {
            Zeison.JCustom jCustom = (Zeison.JCustom)jValue;
            sb.append(jCustom.valueAsJson());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)jValue);
        }
    }

    public static final /* synthetic */ StringBuilder $anonfun$org$tsers$zeison$Rendering$$renderRecursive$1(StringBuilder sb$1, char c) {
        StringBuilder stringBuilder;
        char c2 = c;
        switch (c2) {
            case '\"': {
                stringBuilder = sb$1.append("\\\"");
                break;
            }
            case '\\': {
                stringBuilder = sb$1.append("\\\\");
                break;
            }
            case '\n': {
                stringBuilder = sb$1.append("\\n");
                break;
            }
            case '\r': {
                stringBuilder = sb$1.append("\\r");
                break;
            }
            case '\t': {
                stringBuilder = sb$1.append("\\t");
                break;
            }
            case '\b': {
                stringBuilder = sb$1.append("\\b");
                break;
            }
            case '\f': {
                stringBuilder = sb$1.append("\\f");
                break;
            }
            case '/': {
                stringBuilder = sb$1.append("\\/");
                break;
            }
            default: {
                if (c2 >= '\u0000' && c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f' || c2 >= '\u2000' && c2 <= '\u20ff') {
                    sb$1.append("\\u");
                    sb$1.append(MODULE$.Hex().charAt(c2 >> 12 & 0xF));
                    sb$1.append(MODULE$.Hex().charAt(c2 >> 8 & 0xF));
                    sb$1.append(MODULE$.Hex().charAt(c2 >> 4 & 0xF));
                    stringBuilder = sb$1.append(MODULE$.Hex().charAt(c2 >> 0 & 0xF));
                    break;
                }
                stringBuilder = sb$1.append(c2);
                break;
            }
        }
        return stringBuilder;
    }

    private static final void renderStr$1(String str, StringBuilder sb) {
        sb.append('\"');
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)c -> Rendering$.$anonfun$org$tsers$zeison$Rendering$$renderRecursive$1(sb, BoxesRunTime.unboxToChar((Object)c)));
        sb.append('\"');
    }

    public static final /* synthetic */ void $anonfun$org$tsers$zeison$Rendering$$renderRecursive$2(BooleanRef isFirst$1, StringBuilder sb$2, Tuple2 f) {
        block3: {
            StringBuilder stringBuilder;
            Tuple2 tuple2 = f;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Zeison.JValue value = (Zeison.JValue)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)value);
            Tuple2 tuple23 = tuple22;
            String key2 = (String)tuple23._1();
            Zeison.JValue value2 = (Zeison.JValue)tuple23._2();
            if (!value2.isDefined()) break block3;
            if (!isFirst$1.elem) {
                stringBuilder = sb$2.append(',');
            } else {
                isFirst$1.elem = false;
                stringBuilder = BoxedUnit.UNIT;
            }
            Rendering$.renderStr$1(key2, sb$2);
            sb$2.append(':');
            MODULE$.org$tsers$zeison$Rendering$$renderRecursive(value2, sb$2, false, 0);
        }
    }

    private static final void compactObject$1(Map fields, StringBuilder sb$2) {
        sb$2.append('{');
        BooleanRef isFirst = BooleanRef.create((boolean)true);
        fields.foreach((Function1 & Serializable)f -> {
            Rendering$.$anonfun$org$tsers$zeison$Rendering$$renderRecursive$2(isFirst, sb$2, f);
            return BoxedUnit.UNIT;
        });
        sb$2.append('}');
    }

    public static final /* synthetic */ void $anonfun$org$tsers$zeison$Rendering$$renderRecursive$3(BooleanRef isFirst$2, StringBuilder sb$2, Zeison.JValue e) {
        block2: {
            StringBuilder stringBuilder;
            if (!e.isDefined()) break block2;
            if (!isFirst$2.elem) {
                stringBuilder = sb$2.append(',');
            } else {
                isFirst$2.elem = false;
                stringBuilder = BoxedUnit.UNIT;
            }
            MODULE$.org$tsers$zeison$Rendering$$renderRecursive(e, sb$2, false, 0);
        }
    }

    private static final void compactArray$1(Vector elems, StringBuilder sb$2) {
        sb$2.append('[');
        BooleanRef isFirst = BooleanRef.create((boolean)true);
        elems.foreach((Function1 & Serializable)e -> {
            Rendering$.$anonfun$org$tsers$zeison$Rendering$$renderRecursive$3(isFirst, sb$2, e);
            return BoxedUnit.UNIT;
        });
        sb$2.append(']');
    }

    public static final /* synthetic */ void $anonfun$org$tsers$zeison$Rendering$$renderRecursive$4(BooleanRef isFirst$3, StringBuilder sb$2, String spaces$1, int indent$1, Zeison.JValue e) {
        block2: {
            StringBuilder stringBuilder;
            if (!e.isDefined()) break block2;
            if (!isFirst$3.elem) {
                stringBuilder = sb$2.append(",\n");
            } else {
                sb$2.append('\n');
                isFirst$3.elem = false;
                stringBuilder = BoxedUnit.UNIT;
            }
            sb$2.append(spaces$1);
            MODULE$.org$tsers$zeison$Rendering$$renderRecursive(e, sb$2, true, indent$1 + 2);
        }
    }

    private final void prettyArray$1(Vector elems, StringBuilder sb$2, int indent$1) {
        sb$2.append('[');
        if (elems.size() == 1) {
            Zeison.JValue e2 = (Zeison.JValue)elems.head();
            if (e2.isDefined()) {
                this.org$tsers$zeison$Rendering$$renderRecursive((Zeison.JValue)elems.head(), sb$2, true, indent$1);
            }
            sb$2.append(']');
        } else {
            BoxedUnit boxedUnit;
            String spaces = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), indent$1 + 2);
            BooleanRef isFirst = BooleanRef.create((boolean)true);
            elems.foreach((Function1 & Serializable)e -> {
                Rendering$.$anonfun$org$tsers$zeison$Rendering$$renderRecursive$4(isFirst, sb$2, spaces, indent$1, e);
                return BoxedUnit.UNIT;
            });
            if (!isFirst.elem) {
                sb$2.append('\n');
                boxedUnit = sb$2.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), indent$1));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            sb$2.append(']');
        }
    }

    public static final /* synthetic */ void $anonfun$org$tsers$zeison$Rendering$$renderRecursive$5(BooleanRef isFirst$4, StringBuilder sb$2, String spaces$2, int indent$1, Tuple2 f) {
        block3: {
            StringBuilder stringBuilder;
            Tuple2 tuple2 = f;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Zeison.JValue value = (Zeison.JValue)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)value);
            Tuple2 tuple23 = tuple22;
            String key2 = (String)tuple23._1();
            Zeison.JValue value2 = (Zeison.JValue)tuple23._2();
            if (!value2.isDefined()) break block3;
            if (!isFirst$4.elem) {
                stringBuilder = sb$2.append(",\n");
            } else {
                sb$2.append('\n');
                isFirst$4.elem = false;
                stringBuilder = BoxedUnit.UNIT;
            }
            sb$2.append(spaces$2);
            Rendering$.renderStr$1(key2, sb$2);
            sb$2.append(": ");
            MODULE$.org$tsers$zeison$Rendering$$renderRecursive(value2, sb$2, true, indent$1 + 2);
        }
    }

    private static final void prettyObject$1(Map fields, StringBuilder sb$2, int indent$1) {
        BoxedUnit boxedUnit;
        sb$2.append('{');
        String spaces = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), indent$1 + 2);
        BooleanRef isFirst = BooleanRef.create((boolean)true);
        fields.foreach((Function1 & Serializable)f -> {
            Rendering$.$anonfun$org$tsers$zeison$Rendering$$renderRecursive$5(isFirst, sb$2, spaces, indent$1, f);
            return BoxedUnit.UNIT;
        });
        if (!isFirst.elem) {
            sb$2.append('\n');
            boxedUnit = sb$2.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), indent$1));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        sb$2.append('}');
    }

    private Rendering$() {
    }
}

