/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.SimpleOAuthValidator;
import net.oauth.server.OAuthServlet;
import net.oauth.signature.OAuthSignatureMethod;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tsugi.basiclti.Base64;

public class IMSJSONRequest {
    private static final Logger logger = LoggerFactory.getLogger(IMSJSONRequest.class);
    public static final String STATUS = "status";
    public static final String STATUS_CODE = "code";
    public static final String STATUS_DESCRIPTION = "description";
    public static final String CODE_MAJOR_SUCCESS = "success";
    public static final String CODE_MAJOR_FAILURE = "failure";
    public static final String CODE_MAJOR_UNSUPPORTED = "unsupported";
    public String postBody = null;
    private String header = null;
    private String oauth_body_hash = null;
    private String oauth_consumer_key = null;
    private String oauth_signature_method = null;
    public boolean valid = false;
    public String errorMessage = null;
    public String base_string = null;
    private static final String APPLICATION_JSON = "application/json";
    static final String inputTestData = "<?xml version = \"1.0\" encoding = \"UTF-8\"?>\n<imsx_POXEnvelopeRequest xmlns = \"http://www.imsglobal.org/services/ltiv1p1/xsd/imsoms_v1p0\">\n<imsx_POXHeader>\n<imsx_POXRequestHeaderInfo>\n<imsx_version>V1.0</imsx_version>\n<imsx_messageIdentifier>999999123</imsx_messageIdentifier>\n</imsx_POXRequestHeaderInfo>\n</imsx_POXHeader>\n<imsx_POXBody>\n<replaceResultRequest>\n<resultRecord>\n<sourcedGUID>\n<sourcedId>3124567</sourcedId>\n</sourcedGUID>\n<result>\n<resultScore>\n<language>en-us</language>\n<textString>A</textString>\n</resultScore>\n</result>\n</resultRecord>\n</replaceResultRequest>\n</imsx_POXBody>\n</imsx_POXEnvelopeRequest>";

    public String getOAuthConsumerKey() {
        return this.oauth_consumer_key;
    }

    public String getPostBody() {
        return this.postBody;
    }

    public IMSJSONRequest(String oauth_consumer_key, String oauth_secret, HttpServletRequest request) {
        this.loadFromRequest(request);
        if (!this.valid) {
            return;
        }
        this.validateRequest(oauth_consumer_key, oauth_secret, request);
    }

    public IMSJSONRequest(HttpServletRequest request) {
        this.loadFromRequest(request);
    }

    public IMSJSONRequest(String bodyString) {
        this.postBody = bodyString;
    }

    public void loadFromRequest(HttpServletRequest request) {
        this.header = request.getHeader("Authorization");
        this.oauth_body_hash = null;
        this.oauth_signature_method = null;
        if (this.header != null) {
            String[] parms;
            if (this.header.startsWith("OAuth ")) {
                this.header = this.header.substring(5);
            }
            for (String parm : parms = this.header.split(",")) {
                String[] pieces;
                if ((parm = parm.trim()).startsWith("oauth_body_hash=") && (pieces = parm.split("\"")).length == 2) {
                    this.oauth_body_hash = URLDecoder.decode(pieces[1]);
                }
                if (parm.startsWith("oauth_signature_method=") && (pieces = parm.split("\"")).length == 2) {
                    this.oauth_signature_method = URLDecoder.decode(pieces[1]);
                }
                if (!parm.startsWith("oauth_consumer_key=") || (pieces = parm.split("\"")).length != 2) continue;
                this.oauth_consumer_key = URLDecoder.decode(pieces[1]);
            }
        }
        if (this.oauth_body_hash == null) {
            this.errorMessage = "Did not find oauth_body_hash";
            logger.info(this.errorMessage + "\n" + this.header);
            return;
        }
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int chars = 0;
        try {
            int readNum;
            ServletInputStream is = request.getInputStream();
            do {
                if ((readNum = is.read(buf)) <= 0) continue;
                bos.write(buf, 0, readNum);
                if ((chars += readNum) <= 10000000) continue;
                this.errorMessage = "Message body size exceeded";
                return;
            } while (readNum >= 0);
        }
        catch (Exception e) {
            this.errorMessage = "Could not read message body:" + e.getMessage();
            return;
        }
        byte[] bytes = bos.toByteArray();
        try {
            this.postBody = new String(bytes, "UTF-8");
            MessageDigest md = null;
            md = "HMAC-SHA256".equalsIgnoreCase(this.oauth_signature_method) ? MessageDigest.getInstance("SHA-256") : MessageDigest.getInstance("SHA-1");
            md.update(bytes);
            byte[] output = Base64.encode(md.digest());
            String hash = new String(output);
            if (!hash.equals(this.oauth_body_hash)) {
                this.errorMessage = "Body hash does not match. bytes=" + bytes.length;
                if (this.oauth_signature_method != null) {
                    this.errorMessage = this.errorMessage + " oauth_signature_method=" + this.oauth_signature_method;
                }
                return;
            }
        }
        catch (Exception e) {
            this.errorMessage = "Could not compute body hash.  bytes=" + bytes.length;
            if (this.oauth_signature_method != null) {
                this.errorMessage = this.errorMessage + " oauth_signature_method=" + this.oauth_signature_method;
            }
            this.errorMessage = this.errorMessage + " Exception:" + e.getMessage();
            return;
        }
        this.valid = true;
    }

    public void validateRequest(String oauth_consumer_key, String oauth_secret, HttpServletRequest request) {
        this.validateRequest(oauth_consumer_key, oauth_secret, request, null);
    }

    public void validateRequest(String oauth_consumer_key, String oauth_secret, HttpServletRequest request, String URL2) {
        this.valid = false;
        OAuthMessage oam = OAuthServlet.getMessage(request, URL2);
        SimpleOAuthValidator oav = new SimpleOAuthValidator();
        OAuthConsumer cons = new OAuthConsumer("about:blank#OAuth+CallBack+NotUsed", oauth_consumer_key, oauth_secret, null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        try {
            this.base_string = OAuthSignatureMethod.getBaseString(oam);
        }
        catch (Exception e) {
            this.base_string = null;
        }
        try {
            oav.validateMessage(oam, acc);
        }
        catch (Exception e) {
            this.errorMessage = "Launch fails OAuth validation: " + e.getMessage();
            return;
        }
        this.valid = true;
    }

    public boolean inArray(String[] theArray, String theString) {
        if (theString == null) {
            return false;
        }
        for (String str : theArray) {
            if (!theString.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> getStatusUnsupported(String desc) {
        return IMSJSONRequest.getStatus(desc, CODE_MAJOR_UNSUPPORTED);
    }

    public static Map<String, String> getStatusFailure(String desc) {
        return IMSJSONRequest.getStatus(desc, CODE_MAJOR_FAILURE);
    }

    public static Map<String, String> getStatusSuccess(String desc) {
        return IMSJSONRequest.getStatus(desc, CODE_MAJOR_SUCCESS);
    }

    public static Map<String, String> getStatus(String description, String major) {
        LinkedHashMap<String, String> retval = new LinkedHashMap<String, String>();
        retval.put(STATUS_CODE, major);
        retval.put(STATUS_DESCRIPTION, description);
        return retval;
    }

    public static String doErrorJSON(HttpServletRequest request, HttpServletResponse response, IMSJSONRequest json, String message, Exception e) throws IOException {
        response.setContentType(APPLICATION_JSON);
        response.setStatus(400);
        TreeMap<String, Object> jsonResponse = new TreeMap<String, Object>();
        Map<String, String> status = null;
        if (json == null) {
            status = IMSJSONRequest.getStatusFailure(message);
        } else {
            status = IMSJSONRequest.getStatusFailure(message);
            if (json.base_string != null) {
                jsonResponse.put("base_string", json.base_string);
            }
            if (json.errorMessage != null) {
                jsonResponse.put("error_message", json.errorMessage);
            }
        }
        jsonResponse.put(STATUS, status);
        if (e != null) {
            jsonResponse.put("exception", e.getLocalizedMessage());
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, true);
                e.printStackTrace(pw);
                pw.flush();
                sw.flush();
                jsonResponse.put("traceback", sw.toString());
            }
            catch (Exception f) {
                jsonResponse.put("traceback", f.getLocalizedMessage());
            }
        }
        String jsonText = JSONValue.toJSONString(jsonResponse);
        PrintWriter out = response.getWriter();
        out.println(jsonText);
        return jsonText;
    }

    public static void runTest() {
    }
}

