/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.lti2;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.tsugi.basiclti.BasicLTIUtil;

public class LTI2Util {
    private static Logger M_log = Logger.getLogger(LTI2Util.class.toString());
    public static final String SCOPE_LtiLink = "LtiLink";
    public static final String SCOPE_ToolProxyBinding = "ToolProxyBinding";
    public static final String SCOPE_ToolProxy = "ToolProxy";
    private static final String EMPTY_JSON_OBJECT = "{\n}\n";

    public static Object getSettings(HttpServletRequest request, String scope, JSONObject link_settings, JSONObject binding_settings, JSONObject proxy_settings, String link_url, String binding_url, String proxy_url) {
        boolean acceptComplex;
        String bubbleStr = request.getParameter("bubble");
        String acceptHdr = request.getHeader("Accept");
        String contentHdr = request.getContentType();
        if (bubbleStr != null && bubbleStr.equals("all") && acceptHdr.indexOf("application/vnd.ims.lti.v2.toolsettings+json") < 0) {
            return "Simple format does not allow bubble=all";
        }
        if (!(SCOPE_LtiLink.equals(scope) || SCOPE_ToolProxyBinding.equals(scope) || SCOPE_ToolProxy.equals(scope))) {
            return "Bad Setttings Scope=" + scope;
        }
        boolean bubble = bubbleStr != null && "GET".equals(request.getMethod());
        boolean distinct = bubbleStr != null && "distinct".equals(bubbleStr);
        boolean bubbleAll = bubbleStr != null && "all".equals(bubbleStr);
        boolean bl = acceptComplex = acceptHdr == null || acceptHdr.indexOf("application/vnd.ims.lti.v2.toolsettings+json") >= 0;
        if (distinct && link_settings != null && scope.equals(SCOPE_LtiLink)) {
            for (String key : link_settings.keySet()) {
                if (binding_settings != null) {
                    binding_settings.remove((Object)key);
                }
                if (proxy_settings == null) continue;
                proxy_settings.remove((Object)key);
            }
        }
        if (distinct && binding_settings != null && scope.equals(SCOPE_ToolProxyBinding)) {
            for (String key : binding_settings.keySet()) {
                if (proxy_settings == null) continue;
                proxy_settings.remove((Object)key);
            }
        }
        if (binding_settings != null) {
            binding_settings.remove((Object)"@id");
        }
        if (link_settings != null) {
            link_settings.remove((Object)"@id");
        }
        if (proxy_settings != null) {
            proxy_settings.remove((Object)"@id");
        }
        M_log.fine("link_settings=" + link_settings);
        M_log.fine("proxy_settings=" + proxy_settings);
        M_log.fine("binding_settings=" + binding_settings);
        JSONObject jsonResponse = null;
        if ((distinct || bubbleAll) && acceptComplex) {
            JSONObject cjson;
            jsonResponse = new JSONObject();
            jsonResponse.put((Object)"@context", (Object)"http://purl.imsglobal.org/ctx/lti/v2/ToolSettings");
            JSONArray graph = new JSONArray();
            boolean started = false;
            if (link_settings != null && SCOPE_LtiLink.equals(scope)) {
                cjson = new JSONObject();
                cjson.put((Object)"@id", (Object)link_url);
                cjson.put((Object)"@type", (Object)SCOPE_LtiLink);
                cjson.put((Object)"custom", (Object)link_settings);
                graph.add((Object)cjson);
                started = true;
            }
            if (binding_settings != null && (started || SCOPE_ToolProxyBinding.equals(scope))) {
                cjson = new JSONObject();
                cjson.put((Object)"@id", (Object)binding_url);
                cjson.put((Object)"@type", (Object)SCOPE_ToolProxyBinding);
                cjson.put((Object)"custom", (Object)binding_settings);
                graph.add((Object)cjson);
                started = true;
            }
            if (proxy_settings != null && (started || SCOPE_ToolProxy.equals(scope))) {
                cjson = new JSONObject();
                cjson.put((Object)"@id", (Object)proxy_url);
                cjson.put((Object)"@type", (Object)SCOPE_ToolProxy);
                cjson.put((Object)"custom", (Object)proxy_settings);
                graph.add((Object)cjson);
            }
            jsonResponse.put((Object)"@graph", (Object)graph);
        } else if (distinct) {
            jsonResponse = proxy_settings;
            if (SCOPE_LtiLink.equals(scope)) {
                jsonResponse.putAll((Map)binding_settings);
                jsonResponse.putAll((Map)link_settings);
            } else if (SCOPE_ToolProxyBinding.equals(scope)) {
                jsonResponse.putAll((Map)binding_settings);
            }
        } else {
            jsonResponse = new JSONObject();
            jsonResponse.put((Object)"@context", (Object)"http://purl.imsglobal.org/ctx/lti/v2/ToolSettings");
            JSONObject theSettings = null;
            String endpoint = null;
            if (SCOPE_LtiLink.equals(scope)) {
                endpoint = link_url;
                theSettings = link_settings;
            } else if (SCOPE_ToolProxyBinding.equals(scope)) {
                endpoint = binding_url;
                theSettings = binding_settings;
            }
            if (SCOPE_ToolProxy.equals(scope)) {
                endpoint = proxy_url;
                theSettings = proxy_settings;
            }
            if (acceptComplex) {
                JSONArray graph = new JSONArray();
                JSONObject cjson = new JSONObject();
                cjson.put((Object)"@id", (Object)endpoint);
                cjson.put((Object)"@type", (Object)scope);
                cjson.put((Object)"custom", (Object)theSettings);
                graph.add((Object)cjson);
                jsonResponse.put((Object)"@graph", (Object)graph);
            } else {
                jsonResponse = theSettings;
            }
        }
        return jsonResponse;
    }

    public static JSONArray forceArray(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONArray) {
            return (JSONArray)obj;
        }
        JSONArray retval = new JSONArray();
        retval.add(obj);
        return retval;
    }

    public static JSONArray getArray(JSONObject obj, String key) {
        if (obj == null) {
            return null;
        }
        Object o = obj.get((Object)key);
        if (o == null) {
            return null;
        }
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        if (o instanceof JSONObject) {
            JSONArray retval = new JSONArray();
            retval.add(o);
            return retval;
        }
        String className = o.getClass().getName();
        if (className.startsWith("java.lang")) {
            JSONArray retval = new JSONArray();
            retval.add(o);
            return retval;
        }
        return null;
    }

    public static JSONObject getObject(JSONObject obj, String key) {
        if (obj == null) {
            return null;
        }
        Object o = obj.get((Object)key);
        if (o == null) {
            return null;
        }
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        return null;
    }

    public static String getString(JSONObject obj, String key) {
        if (obj == null) {
            return null;
        }
        Object o = obj.get((Object)key);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static JSONObject parseJSONObject(String toolProfileString) {
        if (toolProfileString == null || toolProfileString.length() < 1) {
            return null;
        }
        Object tp = JSONValue.parse((String)toolProfileString);
        if (tp == null || !(tp instanceof JSONObject)) {
            return null;
        }
        return (JSONObject)tp;
    }

    public static JSONObject parseSettings(String settings) {
        if (settings == null || settings.length() < 1) {
            settings = EMPTY_JSON_OBJECT;
        }
        return (JSONObject)JSONValue.parse((String)settings);
    }

    public static boolean mergeLTI1Custom(Properties custom, String customstr) {
        if (customstr == null || customstr.length() < 1) {
            return true;
        }
        String splitChar = "\n";
        String[] params = customstr.split(splitChar);
        for (int i = 0; i < params.length; ++i) {
            String value;
            String key;
            int pos;
            String param = params[i];
            if (param == null || param.length() < 1 || (pos = param.indexOf("=")) < 1 || pos + 1 > param.length() || (key = LTI2Util.mapKeyName(param.substring(0, pos))) == null || custom.containsKey(key) || (value = param.substring(pos + 1)) == null || (value = value.trim()).length() < 1) continue;
            LTI2Util.setProperty(custom, key, value);
        }
        return true;
    }

    public static boolean mergeLTI2Custom(Properties custom, String customstr) {
        if (customstr == null || customstr.length() < 1) {
            return true;
        }
        JSONObject json = null;
        try {
            json = (JSONObject)JSONValue.parse((String)customstr.trim());
        }
        catch (Exception e) {
            M_log.warning("mergeLTI2Custom could not parse\n" + customstr);
            M_log.warning(e.getLocalizedMessage());
            return false;
        }
        if (json == null) {
            return false;
        }
        for (String key : json.keySet()) {
            Object value;
            if (custom.containsKey(key) || !((value = json.get((Object)key)) instanceof String)) continue;
            LTI2Util.setProperty(custom, key, (String)value);
        }
        return true;
    }

    public static boolean mergeLTI2Parameters(Properties custom, String customstr) {
        if (customstr == null || customstr.length() < 1) {
            return true;
        }
        JSONArray json = null;
        try {
            json = (JSONArray)JSONValue.parse((String)customstr.trim());
        }
        catch (Exception e) {
            M_log.warning("mergeLTI2Parameters could not parse\n" + customstr);
            M_log.warning(e.getLocalizedMessage());
            return false;
        }
        for (Object o : json) {
            JSONObject parameter = null;
            try {
                parameter = (JSONObject)o;
            }
            catch (Exception e) {
                M_log.warning("mergeLTI2Parameters did not find list of objects\n" + customstr);
                M_log.warning(e.getLocalizedMessage());
                return false;
            }
            String name = (String)parameter.get((Object)"name");
            if (name == null || custom.containsKey(name)) continue;
            String fixed = (String)parameter.get((Object)"fixed");
            String variable = (String)parameter.get((Object)"variable");
            if (variable != null) {
                LTI2Util.setProperty(custom, name, variable);
                continue;
            }
            if (fixed == null) continue;
            LTI2Util.setProperty(custom, name, fixed);
        }
        return true;
    }

    public static void substituteCustom(Properties custom, Properties lti2subst) {
        if (custom == null || lti2subst == null) {
            return;
        }
        Enumeration<?> e = custom.propertyNames();
        while (e.hasMoreElements()) {
            String newValue;
            String key = (String)e.nextElement();
            String value = custom.getProperty(key);
            if (value == null || value.length() < 1) continue;
            if (value.startsWith("$") && value.length() > 1) {
                value = value.substring(1);
            }
            if ((newValue = lti2subst.getProperty(value)) == null || newValue.length() < 1) continue;
            LTI2Util.setProperty(custom, key, newValue);
        }
    }

    public static void addCustomToLaunch(Properties ltiProps, Properties custom, boolean isLTI1) {
        Enumeration<?> e = custom.propertyNames();
        while (e.hasMoreElements()) {
            String keyStr = (String)e.nextElement();
            String value = custom.getProperty(keyStr);
            LTI2Util.setProperty(ltiProps, "custom_" + keyStr, value);
            String mapKeyStr = LTI2Util.mapKeyName(keyStr);
            if (!isLTI1 || mapKeyStr.equals(keyStr)) continue;
            LTI2Util.setProperty(ltiProps, "custom_" + mapKeyStr, value);
        }
    }

    public static void filterLTI1LaunchProperties(Properties ltiProps, JSONArray enabledCapabilities, boolean allowExt) {
        Properties mapping = LTI2Util.property2CapabilityMapping();
        Properties oldProps = new Properties(ltiProps);
        Enumeration<?> e = oldProps.propertyNames();
        while (e.hasMoreElements()) {
            String keyStr = (String)e.nextElement();
            if (keyStr.equals("resource_link_id") || keyStr.equals("lti_version") || allowExt && keyStr.startsWith("ext_")) continue;
            String capStr = LTI2Util.property2Capability(keyStr);
            String mapStr = mapping.getProperty(keyStr, null);
            if (enabledCapabilities.contains((Object)keyStr) || capStr != null && enabledCapabilities.contains((Object)capStr) || mapStr != null && enabledCapabilities.contains((Object)mapStr)) continue;
            ltiProps.remove(keyStr);
        }
    }

    public static String property2Capability(String propString) {
        if (propString == null) {
            return null;
        }
        if ((propString = propString.trim()).length() == 0) {
            return "";
        }
        StringBuffer capStr = new StringBuffer();
        capStr.append(propString.substring(0, 1).toUpperCase());
        for (int i = 1; i < propString.length(); ++i) {
            char ch = propString.charAt(i);
            if (ch == ' ') continue;
            if (ch == '_') {
                capStr.append('.');
                continue;
            }
            capStr.append(ch);
        }
        return capStr.toString();
    }

    public static Properties property2CapabilityMapping() {
        Properties mapping = new Properties();
        mapping.setProperty("context_title", "CourseSection.title");
        mapping.setProperty("context_label", "CourseSection.label");
        mapping.setProperty("context_type", "Context.type");
        mapping.setProperty("lis_course_section_sourcedid", "CourseSection.sourcedId");
        mapping.setProperty("resource_link_id", "ResourceLink.id");
        mapping.setProperty("resource_link_title", "ResourceLink.title");
        mapping.setProperty("resource_link_description", "ResourceLink.description");
        mapping.setProperty("lis_person_name_full", "Person.name.full");
        mapping.setProperty("lis_person_name_given", "Person.name.given");
        mapping.setProperty("lis_person_name_family", "Person.name.family");
        mapping.setProperty("lis_person_contact_email_primary", "Person.email.primary");
        mapping.setProperty("lis_person_sourcedid", "Person.sourcedId");
        mapping.setProperty("lis_result_sourcedid", "BasicOutcome.sourcedId");
        mapping.setProperty("lis_outcome_service_url", "BasicOutcome.url");
        mapping.setProperty("launch_presentation_locale", "Message.locale");
        mapping.setProperty("roles", "Membership.role");
        return mapping;
    }

    public static void setProperty(Properties props, String key, String value) {
        BasicLTIUtil.setProperty(props, key, value);
    }

    public static String mapKeyName(String keyname) {
        return BasicLTIUtil.mapKeyName(keyname);
    }

    public static boolean compareServiceIds(String id1, String id2) {
        if (id1 == null && id2 == null) {
            return true;
        }
        if (id1 == null) {
            return false;
        }
        if (id2 == null) {
            return false;
        }
        String[] pieces1 = id1.split("[:#]");
        String[] pieces2 = id2.split("[:#]");
        if (pieces1.length == 0 && pieces2.length == 0) {
            return true;
        }
        if (pieces1.length == 0) {
            return false;
        }
        if (pieces2.length == 0) {
            return false;
        }
        String last1 = pieces1[pieces1.length - 1];
        String last2 = pieces2[pieces2.length - 1];
        return last1.equals(last2);
    }
}

