/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.lti2.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.HashMap;
import java.util.Map;
import org.tsugi.basiclti.BasicLTIUtil;
import org.tsugi.lti2.LTI2Config;
import org.tsugi.lti2.objects.Contact;
import org.tsugi.lti2.objects.Description;
import org.tsugi.lti2.objects.Name;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonPropertyOrder(value={"code", "vendor_name", "description", "website", "timestamp", "contact"})
public class Vendor {
    public static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ssz";
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="vendor_name")
    private Name vendor_name;
    @JsonProperty(value="description")
    private Description description;
    @JsonProperty(value="website")
    private String website;
    @JsonProperty(value="timestamp")
    private String timestamp;
    @JsonProperty(value="contact")
    private Contact contact;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Vendor(LTI2Config cnf) {
        this.code = cnf.getProduct_family_vendor_code();
        this.vendor_name = new Name(cnf.getProduct_family_vendor_name());
        this.description = new Description(cnf.getProduct_family_vendor_description());
        this.website = cnf.getProduct_family_vendor_website();
        this.contact = new Contact(cnf.getProduct_family_vendor_contact());
        this.timestamp = BasicLTIUtil.getISO8601(null);
    }

    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    public void setCode(String code) {
        this.code = code;
    }

    @JsonProperty(value="vendor_name")
    public Name getVendor_name() {
        return this.vendor_name;
    }

    @JsonProperty(value="vendor_name")
    public void setVendor_name(Name vendor_name) {
        this.vendor_name = vendor_name;
    }

    @JsonProperty(value="description")
    public Description getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(Description description) {
        this.description = description;
    }

    @JsonProperty(value="website")
    public String getWebsite() {
        return this.website;
    }

    @JsonProperty(value="website")
    public void setWebsite(String website) {
        this.website = website;
    }

    @JsonProperty(value="timestamp")
    public String getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty(value="contact")
    public Contact getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    public void setContact(Contact contact) {
        this.contact = contact;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperties(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

