/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.lti13;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class LTI13JwtUtil {
    public static final String ID_TOKEN = "id_token";
    public static final String JWT = "JWT";
    public static Long leeway = 60L;

    public static String getBodyAsString(String jws, Key key) {
        return ((Claims)Jwts.parser().setAllowedClockSkewSeconds(leeway.longValue()).setSigningKey(key).parseClaimsJws(jws).getBody()).toString();
    }

    public static String getHeaderAsString(String jws, Key key) {
        return ((JwsHeader)Jwts.parser().setAllowedClockSkewSeconds(leeway.longValue()).setSigningKey(key).parseClaimsJws(jws).getHeader()).toString();
    }

    public static String rawJwtHeader(String encoded) {
        String[] parts = encoded.split("\\.");
        if (parts.length != 2 && parts.length != 3) {
            return null;
        }
        byte[] bytes = Base64.getDecoder().decode(parts[0]);
        return new String(bytes);
    }

    public static JSONObject jsonJwtHeader(String id_token) {
        String headerStr = LTI13JwtUtil.rawJwtHeader(id_token);
        if (headerStr == null) {
            return null;
        }
        Object headerObj = JSONValue.parse((String)headerStr);
        if (headerObj == null) {
            return null;
        }
        if (!(headerObj instanceof JSONObject)) {
            return null;
        }
        return (JSONObject)headerObj;
    }

    public static String rawJwtBody(String encoded) {
        String[] parts = encoded.split("\\.");
        if (parts.length != 2 && parts.length != 3) {
            return null;
        }
        byte[] bytes = Base64.getDecoder().decode(parts[1]);
        return new String(bytes);
    }

    public static JSONObject jsonJwtBody(String id_token) {
        String bodyStr = LTI13JwtUtil.rawJwtBody(id_token);
        if (bodyStr == null) {
            return null;
        }
        Object bodyObj = JSONValue.parse((String)bodyStr);
        if (bodyObj == null) {
            return null;
        }
        if (!(bodyObj instanceof JSONObject)) {
            return null;
        }
        return (JSONObject)bodyObj;
    }

    public static boolean isRequest(HttpServletRequest req) {
        String id_token = req.getParameter(ID_TOKEN);
        return LTI13JwtUtil.isRequest(id_token);
    }

    public static boolean isRequest(String id_token) {
        if (id_token == null) {
            return false;
        }
        JSONObject header = LTI13JwtUtil.jsonJwtHeader(id_token);
        if (header == null) {
            return false;
        }
        JSONObject body = LTI13JwtUtil.jsonJwtBody(id_token);
        if (body == null) {
            return false;
        }
        return body.get((Object)"exp") != null;
    }
}

