/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.lti2;

import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.SimpleOAuthValidator;
import net.oauth.server.OAuthServlet;
import net.oauth.signature.OAuthSignatureMethod;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.tsugi.lti2.LTI2Util;

public class ContentItem {
    public static final String ACCEPT_MEDIA_TYPES = "accept_media_types";
    public static String MEDIA_LTILINKITEM = "application/vnd.ims.lti.v1.ltilink";
    public static final String MEDIA_CC_1_1 = "application/vnd.ims.imsccv1p1";
    public static final String MEDIA_CC_1_2 = "application/vnd.ims.imsccv1p2";
    public static final String MEDIA_CC_1_3 = "application/vnd.ims.imsccv1p3";
    public static final String MEDIA_CC = "application/vnd.ims.imsccv1p3,application/vnd.ims.imsccv1p2,application/vnd.ims.imsccv1p3";
    public static final String TYPE_LTILINKITEM = "LtiLinkItem";
    public static final String TYPE_LTILINK_OLD = "LtiLink";
    public static final String TYPE_CONTENTITEM = "ContentItem";
    public static final String TYPE_FILEITEM = "FileItem";
    public static final String TYPE_IMPORTITEM = "ImportItem";
    public static final String TITLE = "title";
    public static final String TEXT = "text";
    public static final String URL = "url";
    public static final String LINEITEM = "lineItem";
    public static final String CUSTOM = "custom";
    public static final String ICON = "icon";
    HttpServletRequest servletRequest = null;
    private JSONObject contentItem = null;
    private JSONArray graph = null;
    private Properties dataProps = new Properties();
    private String errorMessage = null;
    private String base_string = null;

    public ContentItem(HttpServletRequest req) {
        this.servletRequest = req;
        String content_items = req.getParameter("content_items");
        if (content_items == null || content_items.length() < 1) {
            throw new RuntimeException("Missing content_items= parameter from ContentItem return");
        }
        Object cit = JSONValue.parse((String)content_items);
        if (cit == null || !(cit instanceof JSONObject)) {
            throw new RuntimeException("content_items is wrong type " + cit.getClass().getName());
        }
        this.contentItem = (JSONObject)cit;
        String returnedData = req.getParameter("data");
        if (returnedData == null || returnedData.length() < 1) {
            throw new RuntimeException("Missing data= parameter from ContentItem return");
        }
        Object dat = JSONValue.parse((String)returnedData);
        JSONObject dataJson = null;
        if (dat == null || !(dat instanceof JSONObject)) {
            throw new RuntimeException("data= parameter is wrong type " + dat.getClass().getName());
        }
        dataJson = (JSONObject)dat;
        for (String key : dataJson.keySet()) {
            Object value = dataJson.get((Object)key);
            if (value == null || !(value instanceof String)) continue;
            this.dataProps.setProperty(key, (String)value);
        }
        this.graph = LTI2Util.getArray(this.contentItem, "@graph");
        if (this.graph == null) {
            throw new RuntimeException("A content_item must include a @graph");
        }
    }

    public boolean validate(String oauth_consumer_key, String oauth_secret, String URL2) {
        String req_oauth_consumer_key = this.servletRequest.getParameter("oauth_consumer_key");
        if (req_oauth_consumer_key == null || req_oauth_consumer_key.length() < 1) {
            this.errorMessage = "Missing oauth_consumer_key from incoming request";
            return true;
        }
        if (!req_oauth_consumer_key.equals(oauth_consumer_key)) {
            this.errorMessage = "Mis-match of oauth_consumer_key from incoming request";
            return false;
        }
        OAuthMessage oam = OAuthServlet.getMessage(this.servletRequest, URL2);
        SimpleOAuthValidator oav = new SimpleOAuthValidator();
        OAuthConsumer cons = new OAuthConsumer("about:blank#OAuth+CallBack+NotUsed", oauth_consumer_key, oauth_secret, null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        this.base_string = null;
        try {
            this.base_string = OAuthSignatureMethod.getBaseString(oam);
        }
        catch (Exception e) {
            this.base_string = null;
        }
        try {
            oav.validateMessage(oam, acc);
        }
        catch (Exception e) {
            this.errorMessage = e.getLocalizedMessage();
            return false;
        }
        return true;
    }

    public String toString() {
        return this.contentItem.toString();
    }

    public JSONObject getContentItem() {
        return this.contentItem;
    }

    public JSONArray getGraph() {
        return this.graph;
    }

    public JSONObject getItemOfType(String itemType) {
        for (Object i : this.graph) {
            JSONObject item;
            String type;
            if (!(i instanceof JSONObject) || (type = LTI2Util.getString(item = (JSONObject)i, "@type")) == null || !type.equals(itemType)) continue;
            return item;
        }
        return null;
    }

    public Properties getDataProperties() {
        return this.dataProps;
    }

    public String getBaseString() {
        return this.base_string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static String buildLaunch(String contentLaunch, String contentReturn, Properties contentData) {
        StringBuffer sb = new StringBuffer(contentLaunch);
        if (contentLaunch.indexOf("?") > 1) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append("contentReturn=");
        sb.append(URLEncoder.encode(contentReturn));
        if (contentData == null) {
            return sb.toString();
        }
        Enumeration<Object> en = contentData.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = contentData.getProperty(key);
            if (value == null) continue;
            sb.append("&");
            sb.append(URLEncoder.encode(key));
            sb.append("=");
            sb.append(URLEncoder.encode(value));
        }
        return sb.toString();
    }
}

