/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.lti2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tsugi.basiclti.BasicLTIUtil;
import org.tsugi.json.IMSJSONRequest;
import org.tsugi.lti2.LTI2ConfigSample;
import org.tsugi.lti2.LTI2SampleData;
import org.tsugi.lti2.LTI2Util;
import org.tsugi.lti2.ToolProxy;
import org.tsugi.lti2.objects.Service_offered;
import org.tsugi.lti2.objects.StandardServices;
import org.tsugi.lti2.objects.ToolConsumer;

public class LTI2Servlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(LTI2Servlet.class);
    private static final long serialVersionUID = 1L;
    protected Service_offered LTI2ResultItem = null;
    protected Service_offered LTI2LtiLinkSettings = null;
    protected Service_offered LTI2ToolProxyBindingSettings = null;
    protected Service_offered LTI2ToolProxySettings = null;
    private static final String SVC_tc_profile = "tc_profile";
    private static final String SVC_tc_registration = "tc_registration";
    private static final String SVC_Settings = "Settings";
    private static final String SVC_Result = "Result";
    private static final String EMPTY_JSON_OBJECT = "{\n}\n";
    private static final String APPLICATION_JSON = "application/json";
    private static String TEST_KEY = "42";
    private static String TEST_SECRET = "zaphod";
    private static Map<String, String> PERSIST = new TreeMap<String, String>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.doRequest(request, response);
        }
        catch (Exception e) {
            String ipAddress = request.getRemoteAddr();
            String uri = request.getRequestURI();
            log.warn("General LTI2 Failure URI={} IP={}", (Object)uri, (Object)ipAddress);
            log.error(e.getMessage(), (Throwable)e);
            response.setStatus(500);
            this.doErrorJSON(request, response, null, "General failure", e);
        }
    }

    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("getServiceURL={}", (Object)this.getServiceURL(request));
        String ipAddress = request.getRemoteAddr();
        log.debug("LTI Service request from IP={}", (Object)ipAddress);
        String rpi = request.getPathInfo();
        String uri = request.getRequestURI();
        String[] parts = uri.split("/");
        if (parts.length < 4) {
            response.setStatus(400);
            this.doErrorJSON(request, response, null, "Incorrect url format", null);
            return;
        }
        String controller = parts[3];
        if ("register".equals(controller)) {
            this.doRegister(request, response);
            return;
        }
        if ("launch".equals(controller)) {
            this.doLaunch(request, response);
            return;
        }
        if (SVC_tc_profile.equals(controller) && parts.length == 5) {
            String profile_id = parts[4];
            this.getToolConsumerProfile(request, response, profile_id);
            return;
        }
        if (SVC_tc_registration.equals(controller) && parts.length == 5) {
            String profile_id = parts[4];
            this.registerToolProviderProfile(request, response, profile_id);
            return;
        }
        if (SVC_Result.equals(controller) && parts.length == 5) {
            String sourcedid = parts[4];
            this.handleResultRequest(request, response, sourcedid);
            return;
        }
        if (SVC_Settings.equals(controller) && parts.length >= 6) {
            this.handleSettingsRequest(request, response, parts);
            return;
        }
        IMSJSONRequest jsonRequest = new IMSJSONRequest(request);
        if (jsonRequest.valid) {
            log.debug(jsonRequest.getPostBody());
        }
        response.setStatus(501);
        log.warn("Unknown request={}", (Object)uri);
        this.doErrorJSON(request, response, null, "Unknown request=" + uri, null);
    }

    protected void doRegister(HttpServletRequest request, HttpServletResponse response) {
        PERSIST.clear();
        String launch_url = request.getParameter("launch_url");
        response.setContentType("text/html");
        String output = null;
        if (launch_url != null) {
            Properties ltiProps = new Properties();
            ltiProps.setProperty("lti_version", "LTI-2p0");
            ltiProps.setProperty("reg_key", TEST_KEY);
            ltiProps.setProperty("reg_password", TEST_SECRET);
            ltiProps.setProperty("lti_message_type", "ToolProxyRegistrationRequest");
            String serverUrl = this.getServiceURL(request);
            ltiProps.setProperty("tc_profile_url", serverUrl + SVC_tc_profile + "/" + TEST_KEY);
            ltiProps.setProperty("launch_presentation_return_url", serverUrl + "launch");
            log.debug("ltiProps={}", (Object)ltiProps);
            boolean dodebug = log.isDebugEnabled();
            String launchtext = "Press to Launch External Tool";
            output = BasicLTIUtil.postLaunchHTML(ltiProps, launch_url, launchtext, dodebug, null);
        } else {
            output = "<form>Register URL:<br/><input type=\"text\" name=\"launch_url\" size=\"80\"\nvalue=\"http://localhost:8888/sakai-api-test/tp.php\"><input type=\"submit\">\n";
        }
        try {
            PrintWriter out = response.getWriter();
            out.println(output);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void doLaunch(HttpServletRequest request, HttpServletResponse response) {
        String profile = PERSIST.get("profile");
        response.setContentType("text/html");
        String output = null;
        if (profile == null) {
            output = "Missing profile";
        } else {
            ToolProxy toolProxy = new ToolProxy(profile);
            ArrayList<Properties> profileTools = new ArrayList<Properties>();
            Properties info = new Properties();
            String retval = toolProxy.parseToolProfile(profileTools, info);
            String launch = null;
            String parameter = null;
            for (Properties profileTool : profileTools) {
                launch = (String)profileTool.get("launch");
                parameter = (String)profileTool.get("parameter");
            }
            JSONObject security_contract = toolProxy.getSecurityContract();
            String shared_secret = (String)security_contract.get((Object)"shared_secret");
            log.debug("launch={}", (Object)launch);
            log.debug("shared_secret={}", (Object)shared_secret);
            Properties ltiProps = LTI2SampleData.getLaunch();
            ltiProps.setProperty("lti_version", "LTI-2p0");
            Properties lti2subst = LTI2SampleData.getSubstitution();
            String settings_url = this.getServiceURL(request) + SVC_Settings + "/";
            lti2subst.setProperty("LtiLink.custom.url", settings_url + "LtiLink" + "/" + ltiProps.getProperty("resource_link_id"));
            lti2subst.setProperty("ToolProxyBinding.custom.url", settings_url + "ToolProxyBinding" + "/" + ltiProps.getProperty("context_id"));
            lti2subst.setProperty("ToolProxy.custom.url", settings_url + "ToolProxy" + "/" + TEST_KEY);
            lti2subst.setProperty("Result.url", this.getServiceURL(request) + SVC_Result + "/" + ltiProps.getProperty("resource_link_id"));
            Properties custom = new Properties();
            LTI2Util.mergeLTI2Parameters(custom, parameter);
            LTI2Util.substituteCustom(custom, lti2subst);
            LTI2Util.addCustomToLaunch(ltiProps, custom, false);
            HashMap<String, String> extra = new HashMap<String, String>();
            ltiProps = BasicLTIUtil.signProperties(ltiProps, launch, "POST", TEST_KEY, shared_secret, null, null, null, extra);
            boolean dodebug = log.isDebugEnabled();
            String launchtext = "Press to Launch External Tool";
            output = BasicLTIUtil.postLaunchHTML(ltiProps, launch, launchtext, dodebug, extra);
        }
        try {
            PrintWriter out = response.getWriter();
            out.println(output);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void getToolConsumerProfile(HttpServletRequest request, HttpServletResponse response, String profile_id) {
        Map<String, Object> deploy = null;
        ToolConsumer consumer = this.buildToolConsumerProfile(request, deploy, profile_id);
        ObjectMapper mapper = new ObjectMapper();
        try {
            ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
            response.setContentType(APPLICATION_JSON);
            PrintWriter out = response.getWriter();
            out.println(writer.writeValueAsString((Object)consumer));
            log.debug(writer.writeValueAsString((Object)consumer));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected ToolConsumer buildToolConsumerProfile(HttpServletRequest request, Map<String, Object> deploy, String profile_id) {
        LTI2ConfigSample cnf = new LTI2ConfigSample();
        ToolConsumer consumer = new ToolConsumer(profile_id + "", this.getServiceURL(request) + "#", cnf);
        consumer.allowEmail();
        consumer.allowName();
        consumer.allowSettings();
        consumer.allowResult();
        List<Service_offered> services = consumer.getService_offered();
        services.add(StandardServices.LTI2Registration(this.getServiceURL(request) + SVC_tc_registration + "/" + profile_id));
        services.add(StandardServices.LTI2ResultItem(this.getServiceURL(request) + SVC_Result + "/{" + "lis_result_sourcedid" + "}"));
        services.add(StandardServices.LTI2LtiLinkSettings(this.getServiceURL(request) + SVC_Settings + "/" + "LtiLink" + "/{" + "resource_link_id" + "}"));
        services.add(StandardServices.LTI2ToolProxySettings(this.getServiceURL(request) + SVC_Settings + "/" + "ToolProxyBinding" + "/{" + "context_id" + "}"));
        services.add(StandardServices.LTI2ToolProxySettings(this.getServiceURL(request) + SVC_Settings + "/" + "ToolProxy" + "/{" + "tool_proxy_guid" + "}"));
        return consumer;
    }

    public void registerToolProviderProfile(HttpServletRequest request, HttpServletResponse response, String profile_id) throws IOException {
        if (!TEST_KEY.equals(profile_id)) {
            response.setStatus(404);
            return;
        }
        String key = TEST_KEY;
        String secret = TEST_SECRET;
        IMSJSONRequest jsonRequest = new IMSJSONRequest(request);
        if (!jsonRequest.valid) {
            response.setStatus(400);
            this.doErrorJSON(request, response, jsonRequest, "Request is not in a valid format", null);
            return;
        }
        log.debug(jsonRequest.getPostBody());
        if (key == null || secret == null) {
            response.setStatus(403);
            this.doErrorJSON(request, response, jsonRequest, "Deployment is missing credentials", null);
            return;
        }
        jsonRequest.validateRequest(key, secret, request);
        if (!jsonRequest.valid) {
            response.setStatus(403);
            this.doErrorJSON(request, response, jsonRequest, "OAuth signature failure", null);
            return;
        }
        ToolProxy toolProxy = null;
        try {
            toolProxy = new ToolProxy(jsonRequest.getPostBody());
            log.debug("OBJ:{}", (Object)toolProxy);
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
            response.setStatus(400);
            this.doErrorJSON(request, response, jsonRequest, "JSON parse failed", null);
            return;
        }
        JSONObject default_custom = toolProxy.getCustom();
        JSONObject security_contract = toolProxy.getSecurityContract();
        if (security_contract == null) {
            response.setStatus(400);
            this.doErrorJSON(request, response, jsonRequest, "JSON missing security_contract", null);
            return;
        }
        String shared_secret = (String)security_contract.get((Object)"shared_secret");
        log.debug("shared_secret={}", (Object)shared_secret);
        if (shared_secret == null) {
            response.setStatus(400);
            this.doErrorJSON(request, response, jsonRequest, "JSON missing shared_secret", null);
            return;
        }
        ToolConsumer consumer = this.buildToolConsumerProfile(request, null, profile_id);
        JSONArray tool_services = (JSONArray)security_contract.get((Object)"tool_service");
        String retval = toolProxy.validateServices(consumer);
        if (retval != null) {
            response.setStatus(400);
            this.doErrorJSON(request, response, jsonRequest, retval, null);
            return;
        }
        retval = toolProxy.validateCapabilities(consumer);
        if (retval != null) {
            response.setStatus(400);
            this.doErrorJSON(request, response, jsonRequest, retval, null);
            return;
        }
        PERSIST.put("profile", toolProxy.toString());
        TreeMap<String, String> jsonResponse = new TreeMap<String, String>();
        jsonResponse.put("@context", "http://purl.imsglobal.org/ctx/lti/v2/ToolProxyId");
        jsonResponse.put("@type", "ToolProxy");
        jsonResponse.put("@id", this.getServiceURL(request) + SVC_tc_registration + "/" + profile_id);
        jsonResponse.put("tool_proxy_guid", profile_id);
        response.setContentType("application/vnd.ims.lti.v2.toolproxy.id+json");
        response.setStatus(201);
        String jsonText = JSONValue.toJSONString(jsonResponse);
        log.debug(jsonText);
        PrintWriter out = response.getWriter();
        out.println(jsonText);
    }

    public String getServiceURL(HttpServletRequest request) {
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String url = scheme + "://" + serverName + ":" + serverPort + contextPath + servletPath + "/";
        return url;
    }

    public void handleResultRequest(HttpServletRequest request, HttpServletResponse response, String sourcedid) throws IOException {
        IMSJSONRequest jsonRequest = null;
        String retval = null;
        if ("GET".equals(request.getMethod())) {
            String grade = PERSIST.get("grade");
            String comment = PERSIST.get("comment");
            TreeMap<String, Object> jsonResponse = new TreeMap<String, Object>();
            TreeMap<String, String> resultScore = new TreeMap<String, String>();
            jsonResponse.put("@context", "http://purl.imsglobal.org/ctx/lis/v2/Result");
            jsonResponse.put("@type", SVC_Result);
            resultScore.put("@type", "decimal");
            jsonResponse.put("comment", grade);
            resultScore.put("@value", comment);
            jsonResponse.put("resultScore", resultScore);
            response.setContentType("application/vnd.ims.lis.v2.result+json");
            response.setStatus(200);
            String jsonText = JSONValue.toJSONString(jsonResponse);
            log.debug(jsonText);
            PrintWriter out = response.getWriter();
            out.println(jsonText);
            return;
        }
        if ("PUT".equals(request.getMethod())) {
            retval = "Error parsing input data";
            try {
                jsonRequest = new IMSJSONRequest(request);
                log.debug(jsonRequest.getPostBody());
                JSONObject requestData = (JSONObject)JSONValue.parse((String)jsonRequest.getPostBody());
                String comment = (String)requestData.get((Object)"comment");
                JSONObject resultScore = (JSONObject)requestData.get((Object)"resultScore");
                String sGrade = (String)resultScore.get((Object)"@value");
                Double dGrade = new Double(sGrade);
                PERSIST.put("comment", comment);
                PERSIST.put("grade", dGrade + "");
                response.setStatus(200);
                return;
            }
            catch (Exception e) {
                retval = "Error: " + e.getMessage();
            }
        } else {
            retval = "Unsupported operation:" + request.getMethod();
        }
        response.setStatus(400);
        this.doErrorJSON(request, response, jsonRequest, retval, null);
    }

    public void handleSettingsRequest(HttpServletRequest request, HttpServletResponse response, String[] parts) throws IOException {
        String URL2 = request.getRequestURL().toString();
        log.debug("URL={}", (Object)URL2);
        String scope = parts[4];
        log.debug("scope={}", (Object)scope);
        String acceptHdr = request.getHeader("Accept");
        String contentHdr = request.getContentType();
        boolean acceptComplex = acceptHdr == null || acceptHdr.indexOf("application/vnd.ims.lti.v2.toolsettings+json") >= 0;
        log.debug("accept={} ac={}", (Object)acceptHdr, (Object)acceptComplex);
        IMSJSONRequest jsonRequest = null;
        JSONObject requestData = null;
        if ("PUT".equals(request.getMethod())) {
            try {
                jsonRequest = new IMSJSONRequest(request);
                requestData = (JSONObject)JSONValue.parse((String)jsonRequest.getPostBody());
            }
            catch (Exception e) {
                response.setStatus(400);
                this.doErrorJSON(request, response, jsonRequest, "Could not parse JSON", e);
                return;
            }
        }
        String consumer_key = TEST_KEY;
        String profile = PERSIST.get("profile");
        ToolProxy toolProxy = new ToolProxy(profile);
        JSONObject security_contract = toolProxy.getSecurityContract();
        String oauth_secret = (String)security_contract.get((Object)"shared_secret");
        Object retval = BasicLTIUtil.validateMessage(request, URL2, oauth_secret, consumer_key);
        if (retval instanceof String) {
            response.setStatus(403);
            this.doErrorJSON(request, response, jsonRequest, (String)retval, null);
            return;
        }
        String settingsUrl = this.getServiceURL(request) + SVC_Settings;
        String proxy_url = settingsUrl + "/" + "ToolProxy" + "/" + consumer_key;
        String binding_url = settingsUrl + "/" + "ToolProxyBinding" + "/" + "TBD";
        String link_url = settingsUrl + "/" + "LtiLink" + "/" + "TBD";
        JSONObject link_settings = LTI2Util.parseSettings(PERSIST.get("LtiLink"));
        JSONObject binding_settings = LTI2Util.parseSettings(PERSIST.get("ToolProxyBinding"));
        JSONObject proxy_settings = LTI2Util.parseSettings(PERSIST.get("ToolProxy"));
        if ("GET".equals(request.getMethod())) {
            Object obj = LTI2Util.getSettings(request, scope, link_settings, binding_settings, proxy_settings, link_url, binding_url, proxy_url);
            if (obj instanceof String) {
                response.setStatus(400);
                this.doErrorJSON(request, response, jsonRequest, (String)obj, null);
                return;
            }
            if (acceptComplex) {
                response.setContentType("application/vnd.ims.lti.v2.toolsettings+json");
            } else {
                response.setContentType("application/vnd.ims.lti.v2.toolsettings.simple+json");
            }
            JSONObject jsonResponse = (JSONObject)obj;
            response.setStatus(200);
            PrintWriter out = response.getWriter();
            log.debug("jsonResponse={}", (Object)jsonResponse);
            out.println(jsonResponse.toString());
            return;
        }
        if ("PUT".equals(request.getMethod())) {
            String settings = null;
            try {
                JSONArray graph = (JSONArray)requestData.get((Object)"@graph");
                if (graph.size() != 1) {
                    response.setStatus(400);
                    this.doErrorJSON(request, response, jsonRequest, "Only one graph entry allowed", null);
                    return;
                }
                JSONObject firstChild = (JSONObject)graph.get(0);
                JSONObject custom = (JSONObject)firstChild.get((Object)"custom");
                settings = custom.toString();
            }
            catch (Exception e) {
                settings = jsonRequest.getPostBody();
            }
            PERSIST.put(scope, settings);
            log.debug("Stored settings scope={}", (Object)scope);
            log.debug("settings={}", (Object)settings);
            response.setStatus(200);
        } else {
            response.setStatus(400);
            this.doErrorJSON(request, response, jsonRequest, "Method not handled=" + request.getMethod(), null);
        }
    }

    public void doErrorJSON(HttpServletRequest request, HttpServletResponse response, IMSJSONRequest json, String message, Exception e) throws IOException {
        if (e != null) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        log.info(message);
        String output = IMSJSONRequest.doErrorJSON(request, response, json, message, e);
        log.debug(output);
    }

    public void destroy() {
    }
}

