/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.lti2;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tsugi.lti2.LTI2Util;
import org.tsugi.lti2.ToolProxyBinding;
import org.tsugi.lti2.objects.Service_offered;
import org.tsugi.lti2.objects.ToolConsumer;

public class ToolProxy {
    private static final Logger log = LoggerFactory.getLogger(ToolProxy.class);
    private JSONObject toolProxy = null;

    public ToolProxy(String tool_proxy) {
        if (tool_proxy == null || tool_proxy.trim().length() < 1) {
            throw new RuntimeException("Cannot initialize with empty string");
        }
        Object prox = JSONValue.parse((String)tool_proxy);
        if (prox == null || !(prox instanceof JSONObject)) {
            throw new RuntimeException("tool proxy is wrong type " + prox.getClass().getName());
        }
        this.toolProxy = (JSONObject)prox;
        JSONObject tp = this.getToolProfile();
        if (tp == null) {
            throw new RuntimeException("A tool_proxy must include a tool_profile");
        }
    }

    public String toString() {
        return this.toolProxy.toString();
    }

    public JSONObject getToolProxy() {
        return this.toolProxy;
    }

    public JSONObject getToolProfile() {
        return LTI2Util.getObject(this.toolProxy, "tool_profile");
    }

    public JSONObject getSecurityContract() {
        return LTI2Util.getObject(this.toolProxy, "security_contract");
    }

    public JSONObject getCustom() {
        return LTI2Util.getObject(this.toolProxy, "custom");
    }

    public JSONArray getResourceHandlers() {
        return LTI2Util.getArray(this.getToolProfile(), "resource_handler");
    }

    public JSONObject getMessageOfType(String messageType) {
        return this.getMessageOfType(this.getToolProfile(), messageType);
    }

    public String getPathFromMessage(JSONObject message) {
        if (message == null) {
            return null;
        }
        String path = LTI2Util.getString(message, "path");
        return path;
    }

    public JSONArray getParameterFromMessage(JSONObject message) {
        if (message == null) {
            return null;
        }
        JSONArray parameter = LTI2Util.getArray(message, "parameter");
        return parameter;
    }

    public JSONObject getMessageOfType(JSONObject resourceHandler, String messageType) {
        if (resourceHandler == null || messageType == null || messageType.length() < 1) {
            return null;
        }
        JSONArray messages = LTI2Util.getArray(resourceHandler, "message");
        if (messages == null) {
            return null;
        }
        for (Object m : messages) {
            if (!(m instanceof JSONObject)) {
                return null;
            }
            JSONObject message = (JSONObject)m;
            JSONArray message_type_array = LTI2Util.getArray(message, "message_type");
            if (message_type_array == null) continue;
            for (Object message_type : message_type_array) {
                if (!(message_type instanceof String) || !((String)message_type).equals(messageType)) continue;
                return message;
            }
        }
        return null;
    }

    public JSONArray enabledCapabilities(JSONObject resourceHandler, String messageType) {
        JSONObject message = this.getMessageOfType(resourceHandler, messageType);
        JSONArray enabled_capability = LTI2Util.getArray(message, "enabled_capability");
        if (enabled_capability == null) {
            enabled_capability = new JSONArray();
        }
        return enabled_capability;
    }

    public boolean enabledCapability(JSONObject resourceHandler, String messageType, String capability) {
        JSONArray enabled_capability = this.enabledCapabilities(resourceHandler, messageType);
        if (enabled_capability == null) {
            return false;
        }
        return enabled_capability.contains((Object)capability);
    }

    public String getIconPath(JSONObject resourceHandler, String icon_style) {
        JSONArray icon_info = LTI2Util.getArray(resourceHandler, "icon_info");
        if (icon_info == null) {
            return null;
        }
        for (Object m : icon_info) {
            String default_location_path;
            JSONObject default_location;
            JSONObject jm;
            JSONArray icon_styles;
            if (!(m instanceof JSONObject) || (icon_styles = LTI2Util.getArray(jm = (JSONObject)m, "icon_style")) == null || !icon_styles.contains((Object)icon_style) || (default_location = LTI2Util.getObject(jm, "default_location")) == null || (default_location_path = LTI2Util.getString(default_location, "path")) == null) continue;
            return default_location_path;
        }
        return null;
    }

    public String validateServices(ToolConsumer consumer) {
        try {
            JSONObject security_contract = (JSONObject)this.toolProxy.get((Object)"security_contract");
            if (security_contract == null) {
                return "JSON missing security_contract";
            }
            JSONArray tool_services = (JSONArray)security_contract.get((Object)"tool_service");
            List<Service_offered> services_offered = consumer.getService_offered();
            if (tool_services != null) {
                for (Object o : tool_services) {
                    JSONObject tool_service = (JSONObject)o;
                    String json_service = (String)tool_service.get((Object)"service");
                    boolean found = false;
                    for (Service_offered service : services_offered) {
                        String service_id = service.get_id();
                        if (!LTI2Util.compareServiceIds(service_id, json_service)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return "Service not allowed: " + json_service;
                }
            }
            return null;
        }
        catch (Exception e) {
            return "Exception:" + e.getLocalizedMessage();
        }
    }

    public String validateCapabilities(ToolConsumer consumer) {
        ArrayList<Properties> theTools = new ArrayList<Properties>();
        Properties info = new Properties();
        try {
            String retval = this.parseToolProfile(theTools, info);
            if (retval != null) {
                return retval;
            }
            if (theTools.size() < 1) {
                return "No tools found in profile";
            }
            List<String> capabilities = consumer.getCapability_offered();
            for (Properties theTool : theTools) {
                String ec = (String)theTool.get("enabled_capability");
                JSONArray enabled_capability = (JSONArray)JSONValue.parse((String)ec);
                if (enabled_capability == null) continue;
                for (Object o : enabled_capability) {
                    ec = (String)o;
                    if (capabilities.contains(ec)) continue;
                    return "Capability not permitted=" + ec;
                }
            }
            return null;
        }
        catch (Exception e) {
            return "Exception:" + e.getLocalizedMessage();
        }
    }

    public String parseToolProfile(List<Properties> theTools, Properties info) {
        try {
            return this.parseToolProfileInternal(theTools, info);
        }
        catch (Exception e) {
            log.warn("Internal error parsing tool proxy\n{}", (Object)this.toolProxy.toString());
            log.error(e.getMessage(), (Throwable)e);
            return "Internal error parsing tool proxy:" + e.getLocalizedMessage();
        }
    }

    private String parseToolProfileInternal(List<Properties> theTools, Properties info) {
        JSONArray base_url_choices;
        Object o = null;
        JSONObject tool_profile = this.getToolProfile();
        if (tool_profile == null) {
            return "JSON missing tool_profile";
        }
        JSONObject product_instance = (JSONObject)tool_profile.get((Object)"product_instance");
        if (product_instance == null) {
            return "JSON missing product_instance";
        }
        String instance_guid = (String)product_instance.get((Object)"guid");
        if (instance_guid == null) {
            return "JSON missing product_info / guid";
        }
        info.put("instance_guid", instance_guid);
        JSONObject product_info = (JSONObject)product_instance.get((Object)"product_info");
        if (product_info == null) {
            return "JSON missing product_info";
        }
        JSONObject product_name = LTI2Util.getObject(product_info, "product_name");
        String productTitle = LTI2Util.getString(product_name, "default_value");
        JSONObject description = LTI2Util.getObject(product_info, "description");
        String productDescription = LTI2Util.getString(description, "default_value");
        JSONObject product_family = LTI2Util.getObject(product_info, "product_family");
        String productCode = LTI2Util.getString(product_family, "code");
        JSONObject product_vendor = LTI2Util.getObject(product_family, "vendor");
        description = LTI2Util.getObject(product_vendor, "description");
        String vendorDescription = LTI2Util.getString(description, "default_value");
        String vendorCode = LTI2Util.getString(product_vendor, "code");
        if (productTitle == null) {
            return "JSON missing product_name";
        }
        if (productCode == null || vendorCode == null) {
            return "JSON missing product code or vendor code";
        }
        info.put("product_name", productTitle);
        if (productDescription != null) {
            info.put("description", productDescription);
        }
        if (productDescription != null) {
            info.put("product_description", productDescription);
        }
        info.put("product_code", productCode);
        info.put("vendor_code", vendorCode);
        if (vendorDescription != null) {
            info.put("vendor_description", vendorDescription);
        }
        if ((base_url_choices = LTI2Util.getArray(tool_profile, "base_url_choice")) == null) {
            return "JSON missing base_url_choices";
        }
        String secure_base_url = null;
        String default_base_url = null;
        for (Object i : base_url_choices) {
            JSONObject url_choice = (JSONObject)i;
            secure_base_url = (String)url_choice.get((Object)"secure_base_url");
            default_base_url = (String)url_choice.get((Object)"default_base_url");
        }
        String launch_url = secure_base_url;
        if (launch_url == null) {
            launch_url = default_base_url;
        }
        if (launch_url == null) {
            return "Unable to determine launch URL";
        }
        JSONArray resource_handlers = this.getResourceHandlers();
        if (resource_handlers == null) {
            return "JSON missing resource_handlers";
        }
        for (Object i : resource_handlers) {
            String title;
            JSONObject resource_handler = (JSONObject)i;
            JSONObject resource_type_json = (JSONObject)resource_handler.get((Object)"resource_type");
            String resource_type_code = (String)resource_type_json.get((Object)"code");
            if (resource_type_code == null) {
                return "JSON missing resource_type code";
            }
            JSONArray messages = LTI2Util.getArray(resource_handler, "message");
            if (messages == null) {
                return "JSON missing resource_handler / message";
            }
            JSONObject titleObject = (JSONObject)resource_handler.get((Object)"resource_name");
            String string = title = titleObject == null ? null : (String)titleObject.get((Object)"default_value");
            if (title == null || titleObject == null) {
                return "JSON missing resource_handler / resource_name / default_value";
            }
            JSONObject buttonObject = (JSONObject)resource_handler.get((Object)"short_name");
            String button = buttonObject == null ? null : (String)buttonObject.get((Object)"default_value");
            JSONObject descObject = (JSONObject)resource_handler.get((Object)"description");
            String resourceDescription = LTI2Util.getString(descObject, "default_value");
            JSONArray iconInfo = LTI2Util.getArray(resource_handler, "icon_info");
            String path = null;
            JSONArray parameter = null;
            JSONArray enabled_capability = null;
            for (Object m : messages) {
                JSONObject message = (JSONObject)m;
                String message_type = (String)message.get((Object)"message_type");
                if ("basic-lti-launch-request".equals(message_type) || "ContentItemSelectionRequest".equals(message_type)) {
                    path = (String)message.get((Object)"path");
                    if (path == null) {
                        return "A launch message must have a path RT=" + resource_type_code;
                    }
                    String thisLaunch = launch_url;
                    thisLaunch = thisLaunch + path;
                    try {
                        URL uRL = new URL(thisLaunch);
                    }
                    catch (Exception e) {
                        return "Bad launch URL=" + thisLaunch;
                    }
                    parameter = LTI2Util.getArray(message, "parameter");
                    enabled_capability = LTI2Util.getArray(message, "enabled_capability");
                    Properties theTool = new Properties();
                    theTool.put("resource_type", resource_type_code);
                    theTool.put("resource_type_code", resource_type_code);
                    if (title == null) {
                        title = productTitle;
                    }
                    if (title != null) {
                        theTool.put("title", title);
                    }
                    if (button != null) {
                        theTool.put("button", button);
                    }
                    if (resourceDescription == null) {
                        resourceDescription = productDescription;
                    }
                    if (resourceDescription != null) {
                        theTool.put("description", resourceDescription);
                    }
                    if (parameter != null) {
                        theTool.put("parameter", parameter.toString());
                    }
                    if (iconInfo != null) {
                        theTool.put("icon_info", iconInfo.toString());
                    }
                    theTool.put("enabled_capability", enabled_capability.toString());
                    theTool.put("launch", thisLaunch);
                    if (secure_base_url != null) {
                        theTool.put("secure_base_url", secure_base_url);
                    }
                    if (default_base_url != null) {
                        theTool.put("default_base_url", default_base_url);
                    }
                    if ("basic-lti-launch-request".equals(message_type)) {
                        theTool.put("pl_launch", "1");
                    }
                    if ("ContentItemSelectionRequest".equals(message_type)) {
                        theTool.put("pl_linkselection", "1");
                    }
                    ToolProxy local_tool_proxy = new ToolProxy(this.toolProxy.toString());
                    JSONObject local_tool_profile = local_tool_proxy.getToolProfile();
                    local_tool_profile.remove((Object)"resource_handler");
                    JSONObject local_resource_handler = (JSONObject)JSONValue.parse((String)resource_handler.toString());
                    local_resource_handler.remove((Object)"message");
                    JSONArray local_messages = new JSONArray();
                    local_messages.add((Object)message);
                    local_resource_handler.put((Object)"message", (Object)local_messages);
                    JSONArray handlers = new JSONArray();
                    handlers.add((Object)local_resource_handler);
                    local_tool_profile.put((Object)"resource_handler", (Object)handlers);
                    ToolProxyBinding tool_proxy_binding = new ToolProxyBinding(local_tool_proxy.toString());
                    theTool.put("tool_proxy_binding", tool_proxy_binding.toString());
                    theTools.add(theTool);
                    continue;
                }
                if ("ToolProxyRegistrationRequest".equals(message_type) || "ToolProxyReregistrationRequest".equals(message_type)) continue;
                return "Only basic-lti-launch-request and ContentItemSelectionRequest are allowed message_types RT=" + resource_type_code;
            }
        }
        return null;
    }
}

