/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.tsugi.util.Model;

public class TimeSeries {
    protected int timestart;
    protected int scale;
    protected int maxlen;
    protected int total;
    protected Map<Integer, Integer> buckets;

    public TimeSeries() {
        this.timestart = 0;
        this.scale = 900;
        this.maxlen = 1024;
        this.total = 0;
        this.buckets = new LinkedHashMap<Integer, Integer>();
    }

    public TimeSeries(int timestart, int scale, int maxlen) {
        this.timestart = timestart / scale;
        this.scale = scale;
        this.maxlen = maxlen;
        this.total = 0;
        this.buckets = new LinkedHashMap<Integer, Integer>();
    }

    public void click(int time) throws IOException {
        int delta;
        ++this.total;
        if (this.timestart == 0) {
            this.timestart = (int)System.currentTimeMillis() / 1000 / this.scale;
        }
        if (time == 0) {
            time = (int)System.currentTimeMillis() / 1000;
        }
        if ((delta = (time /= this.scale) - this.timestart) < 0) {
            delta = 0;
        }
        if (this.buckets.containsKey(delta)) {
            this.buckets.put(delta, this.buckets.get(delta) + 1);
        } else {
            this.buckets.put(delta, 1);
        }
    }

    public Map<Integer, Integer> reconstruct() throws IOException {
        LinkedHashMap<Integer, Integer> retval = new LinkedHashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> pair : this.buckets.entrySet()) {
            int t = (this.timestart + pair.getKey()) * this.scale;
            retval.put(t, (int)pair.getValue());
        }
        return retval;
    }

    public Map viewModel() throws IOException {
        final Model retval = new Model();
        this.buckets = this.reconstruct();
        retval.setTimeStart(this.timestart * this.scale);
        retval.setWidth(this.scale);
        int max = 0;
        int maxt = 0;
        int min = 0;
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (Map.Entry<Integer, Integer> pair : this.buckets.entrySet()) {
            if (maxt == 0 || pair.getKey() > maxt) {
                maxt = pair.getKey();
            }
            if (max == 0 || pair.getValue() > max) {
                max = pair.getValue();
            }
            if (min == 0 || pair.getValue() < min) {
                min = pair.getValue();
            }
            rows.add(pair.getKey(), (int)pair.getValue());
        }
        retval.setRows(rows);
        retval.setN(rows.size());
        retval.setMax(max);
        retval.setMin(min);
        retval.setTimeEnd(maxt);
        return new LinkedHashMap(){
            {
                this.put("timestart", retval.timestart);
                this.put("width", retval.width);
                this.put("rows", retval.rows);
                this.put("n", retval.n);
                this.put("max", retval.max);
                this.put("min", retval.min);
                this.put("timeend", retval.timeend);
            }
        };
    }

    public Map<Integer, Integer> rescale(int factor) throws IOException {
        LinkedHashMap<Integer, Integer> newbuckets = new LinkedHashMap<Integer, Integer>();
        int newscale = this.scale * factor;
        int newstart = this.timestart / factor;
        for (Map.Entry<Integer, Integer> pair : this.buckets.entrySet()) {
            int oldtime = (this.timestart + pair.getKey()) * this.scale;
            int newposition = oldtime / newscale;
            int delta = newposition - newstart;
            if (newbuckets.containsKey(delta)) {
                newbuckets.put(delta, (Integer)newbuckets.get(delta) + pair.getValue());
                continue;
            }
            newbuckets.put(delta, (int)pair.getValue());
        }
        return newbuckets;
    }

    public void deserialize(String data) throws IOException {
        String[] chunks = data.split(":");
        if (chunks.length != 3 || !StringUtils.isNumeric((CharSequence)chunks[0]) || !StringUtils.isNumeric((CharSequence)chunks[1])) {
            this.scale = 900;
            this.timestart = 0;
            LinkedHashMap buckets = new LinkedHashMap();
            return;
        }
        this.scale = new Integer(chunks[0]);
        this.timestart = new Integer(chunks[1]);
        this.buckets = this.arrayIntegerDeserialize(chunks[2]);
    }

    public String serialize(int maxlength) throws Exception, IOException {
        String retval;
        if (maxlength == 0) {
            maxlength = this.maxlen;
        }
        if ((retval = Integer.toString(this.scale) + ":" + Integer.toString(this.timestart) + ":" + this.arrayIntegerSerialize(this.buckets)).length() <= maxlength) {
            return retval;
        }
        if (this.scale < 86400) {
            for (int factor = 2; factor <= 4; factor += 2) {
                Map<Integer, Integer> newbuckets = this.rescale(factor);
                int newscale = this.scale * factor;
                int newstart = this.timestart / factor;
                retval = Integer.toString(newscale) + ":" + Integer.toString(newstart) + ":" + this.arrayIntegerSerialize(newbuckets);
                if (retval.length() > maxlength) continue;
                return retval;
            }
        }
        Map<Integer, Integer> oldbuckets = this.buckets;
        int newstart = this.timestart;
        int firstoffset = 0;
        while (oldbuckets.size() > 4) {
            LinkedHashMap<Integer, Integer> fewerbuckets = new LinkedHashMap<Integer, Integer>();
            int pos = 0;
            firstoffset = 0;
            for (Map.Entry<Integer, Integer> entry : oldbuckets.entrySet()) {
                int oldoffset = entry.getKey();
                if (++pos == 1) continue;
                if (pos == 2) {
                    firstoffset = oldoffset;
                }
                int newoffset = oldoffset - firstoffset;
                fewerbuckets.put(newoffset, oldbuckets.get(oldoffset));
            }
            if (oldbuckets.size() - 1 != fewerbuckets.size()) {
                throw new Exception("Internal failure during serialization");
            }
            retval = Integer.toString(this.scale) + ":" + Integer.toString(newstart += firstoffset) + ":" + this.arrayIntegerSerialize(fewerbuckets);
            if (retval.length() <= maxlength) {
                return retval;
            }
            for (Map.Entry<Integer, Integer> entry : fewerbuckets.entrySet()) {
                oldbuckets.put((int)entry.getKey(), (int)entry.getValue());
            }
        }
        return retval;
    }

    public String arrayIntegerSerialize(Map arar) throws IOException {
        String result = "";
        for (Map.Entry pair : arar.entrySet()) {
            result = result + this.arrayIntegerSerializeMap((Integer)pair.getKey(), (Integer)pair.getValue()) + ",";
        }
        return result.substring(0, result.length() - 1);
    }

    public String arrayIntegerSerializeMap(int a, int b) throws IOException {
        return Integer.toString(a) + "=" + Integer.toString(b);
    }

    public Map<Integer, Integer> arrayIntegerDeserialize(String input) throws IOException {
        String[] temp = input.split(",");
        Pattern p = Pattern.compile("([^,= ]+)=([^,= ]+)");
        LinkedHashMap<Integer, Integer> result = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < temp.length; ++i) {
            Matcher m = p.matcher(temp[i]);
            if (!m.matches()) continue;
            result.put(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
        }
        return result;
    }
}

