/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.basiclti;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.SimpleOAuthValidator;
import net.oauth.server.OAuthServlet;
import net.oauth.signature.OAuthSignatureMethod;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tsugi.basiclti.XMLMap;

public class BasicLTIUtil {
    private static final Logger log = LoggerFactory.getLogger(BasicLTIUtil.class);
    public static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ssz";
    public static final String EXTRA_BUTTON_HTML = "button_html";
    public static final String EXTRA_ERROR_TIMEOUT = "error_timeout";
    public static final String EXTRA_HTTP_POPUP = "http_popup";
    public static final String EXTRA_HTTP_POPUP_FALSE = "false";
    private static boolean verbosePrint = false;
    private static final Pattern CUSTOM_REGEX = Pattern.compile("[^A-Za-z0-9]");
    private static final String UNDERSCORE = "_";
    private static final String EMPTY_JSON_OBJECT = "{\n}\n";

    public static boolean isRequest(HttpServletRequest request) {
        String message_type = request.getParameter("lti_message_type");
        if (message_type == null) {
            return false;
        }
        if (!message_type.equals("basic-lti-launch-request") && !message_type.equals("ContentItemSelectionRequest")) {
            return false;
        }
        String version = request.getParameter("lti_version");
        if (version == null) {
            return true;
        }
        return version.equals("LTI-1p0");
    }

    public static Object validateMessage(HttpServletRequest request, String URL2, String oauth_secret, String expected_oauth_key) {
        OAuthMessage oam = OAuthServlet.getMessage(request, URL2);
        String oauth_consumer_key = null;
        try {
            oauth_consumer_key = oam.getConsumerKey();
        }
        catch (Exception e) {
            return "Unable to find consumer key in message";
        }
        if (expected_oauth_key != null && !expected_oauth_key.equals(oauth_consumer_key)) {
            log.warn("BasicLTIUtil.validateMessage Incorrect consumer key={} expected key={}", (Object)oauth_consumer_key, (Object)expected_oauth_key);
            return "Incorrect consumer key " + oauth_consumer_key;
        }
        SimpleOAuthValidator oav = new SimpleOAuthValidator();
        OAuthConsumer cons = new OAuthConsumer("about:blank#OAuth+CallBack+NotUsed", oauth_consumer_key, oauth_secret, null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        String base_string = null;
        try {
            base_string = OAuthSignatureMethod.getBaseString(oam);
        }
        catch (Exception e) {
            return "Unable to find base string";
        }
        try {
            oav.validateMessage(oam, acc);
        }
        catch (Exception e) {
            if (base_string != null) {
                return "Failed to validate: " + e.getLocalizedMessage() + "\nBase String\n" + base_string;
            }
            return "Failed to validate: " + e.getLocalizedMessage();
        }
        return Boolean.TRUE;
    }

    public static String validateDescriptor(String descriptor) {
        if (descriptor == null) {
            return null;
        }
        if (descriptor.indexOf("<basic_lti_link") < 0) {
            return null;
        }
        Map<String, Object> tm = XMLMap.getFullMap(descriptor.trim());
        if (tm == null) {
            return null;
        }
        String ltiSecureLaunch = XMLMap.getString(tm, "/basic_lti_link/secure_launch_url");
        if (ltiSecureLaunch != null && ltiSecureLaunch.trim().length() > 0) {
            return ltiSecureLaunch;
        }
        String ltiLaunch = XMLMap.getString(tm, "/basic_lti_link/launch_url");
        if (ltiLaunch != null && ltiLaunch.trim().length() > 0) {
            return ltiLaunch;
        }
        return null;
    }

    public static String adaptToCustomPropertyName(String propertyName) {
        if (propertyName == null || "".equals(propertyName)) {
            throw new IllegalArgumentException("propertyName cannot be null");
        }
        String customName = propertyName.toLowerCase();
        if (!(customName = CUSTOM_REGEX.matcher(customName).replaceAll(UNDERSCORE)).startsWith("custom_")) {
            customName = "custom_" + customName;
        }
        return customName;
    }

    public static Properties signProperties(Properties postProp, String url, String method, String oauth_consumer_key, String oauth_consumer_secret, Map<String, String> extra) {
        Map<String, String> signedMap = BasicLTIUtil.signProperties(BasicLTIUtil.convertToMap(postProp), url, method, oauth_consumer_key, oauth_consumer_secret, null, null, null, null, null, extra);
        return BasicLTIUtil.convertToProperties(signedMap);
    }

    public static Properties signProperties(Properties postProp, String url, String method, String oauth_consumer_key, String oauth_consumer_secret, String org_id, String org_desc, String org_url, Map<String, String> extra) {
        Map<String, String> signedMap = BasicLTIUtil.signProperties(BasicLTIUtil.convertToMap(postProp), url, method, oauth_consumer_key, oauth_consumer_secret, org_id, org_desc, org_url, null, null, extra);
        return BasicLTIUtil.convertToProperties(signedMap);
    }

    public static Map<String, String> signProperties(Map<String, String> postProp, String url, String method, String oauth_consumer_key, String oauth_consumer_secret, String tool_consumer_instance_guid, String tool_consumer_instance_description, String tool_consumer_instance_url, String tool_consumer_instance_name, String tool_consumer_instance_contact_email, Map<String, String> extra) {
        if (tool_consumer_instance_guid != null) {
            postProp.put("tool_consumer_instance_guid", tool_consumer_instance_guid);
        }
        if (tool_consumer_instance_description != null) {
            postProp.put("tool_consumer_instance_description", tool_consumer_instance_description);
        }
        if (tool_consumer_instance_url != null) {
            postProp.put("tool_consumer_instance_url", tool_consumer_instance_url);
        }
        if (tool_consumer_instance_name != null) {
            postProp.put("tool_consumer_instance_name", tool_consumer_instance_name);
        }
        if (tool_consumer_instance_contact_email != null) {
            postProp.put("tool_consumer_instance_contact_email", tool_consumer_instance_contact_email);
        }
        return BasicLTIUtil.signProperties(postProp, url, method, oauth_consumer_key, oauth_consumer_secret, extra);
    }

    public static Map<String, String> signProperties(Map<String, String> postProp, String url, String method, String oauth_consumer_key, String oauth_consumer_secret, Map<String, String> extra) {
        if (postProp.get("lti_version") == null) {
            postProp.put("lti_version", "LTI-1p0");
        }
        if (postProp.get("lti_message_type") == null) {
            postProp.put("lti_message_type", "basic-lti-launch-request");
        }
        if (postProp.get("oauth_callback") == null) {
            postProp.put("oauth_callback", "about:blank");
        }
        if (oauth_consumer_key == null || oauth_consumer_secret == null) {
            log.debug("No signature generated in signProperties");
            return postProp;
        }
        OAuthMessage oam = new OAuthMessage(method, url, postProp.entrySet());
        OAuthConsumer cons = new OAuthConsumer("about:blank", oauth_consumer_key, oauth_consumer_secret, null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        try {
            oam.addRequiredParameters(acc);
            String base_string = OAuthSignatureMethod.getBaseString(oam);
            log.debug("Base Message String\n{}\n", (Object)base_string);
            if (extra != null) {
                extra.put("BaseString", base_string);
            }
            List<Map.Entry<String, String>> params = oam.getParameters();
            HashMap<String, String> nextProp = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : params) {
                nextProp.put(entry.getKey(), entry.getValue());
            }
            return nextProp;
        }
        catch (OAuthException e) {
            log.warn("BasicLTIUtil.signProperties OAuth Exception {}", (Object)e.getMessage());
            throw new Error(e);
        }
        catch (IOException e) {
            log.warn("BasicLTIUtil.signProperties IO Exception {}", (Object)e.getMessage());
            throw new Error(e);
        }
        catch (URISyntaxException e) {
            log.warn("BasicLTIUtil.signProperties URI Syntax Exception {}", (Object)e.getMessage());
            throw new Error(e);
        }
    }

    public static boolean checkProperties(Properties postProp, String url, String method, String oauth_consumer_key, String oauth_consumer_secret) {
        return BasicLTIUtil.checkProperties(BasicLTIUtil.convertToMap(postProp), url, method, oauth_consumer_key, oauth_consumer_secret);
    }

    public static boolean checkProperties(Map<String, String> postProp, String url, String method, String oauth_consumer_key, String oauth_consumer_secret) {
        OAuthMessage oam = new OAuthMessage(method, url, postProp.entrySet());
        OAuthConsumer cons = new OAuthConsumer("about:blank", oauth_consumer_key, oauth_consumer_secret, null);
        SimpleOAuthValidator oav = new SimpleOAuthValidator();
        OAuthAccessor acc = new OAuthAccessor(cons);
        String base_string = null;
        try {
            base_string = OAuthSignatureMethod.getBaseString(oam);
        }
        catch (Exception e) {
            log.warn(e.getLocalizedMessage());
            base_string = null;
            return false;
        }
        try {
            oav.validateMessage(oam, acc);
        }
        catch (Exception e) {
            log.warn("Provider failed to validate message");
            log.warn(e.getLocalizedMessage());
            if (base_string != null) {
                log.warn(base_string);
            }
            return false;
        }
        return true;
    }

    public static String postLaunchHTML(Properties cleanProperties, String endpoint, String launchtext, boolean debug, Map<String, String> extra) {
        Map<String, String> map = BasicLTIUtil.convertToMap(cleanProperties);
        return BasicLTIUtil.postLaunchHTML(map, endpoint, launchtext, debug, extra);
    }

    public static String postLaunchHTML(Properties cleanProperties, String endpoint, String launchtext, boolean autosubmit, boolean debug, Map<String, String> extra) {
        Map<String, String> map = BasicLTIUtil.convertToMap(cleanProperties);
        return BasicLTIUtil.postLaunchHTML(map, endpoint, launchtext, autosubmit, debug, extra);
    }

    public static String postLaunchHTML(Map<String, String> cleanProperties, String endpoint, String launchtext, boolean debug, Map<String, String> extra) {
        boolean autosubmit = true;
        return BasicLTIUtil.postLaunchHTML(cleanProperties, endpoint, launchtext, autosubmit, debug, extra);
    }

    public static String postLaunchHTML(Map<String, String> cleanProperties, String endpoint, String launchtext, boolean autosubmit, boolean debug, Map<String, String> extra) {
        String button_html;
        if (cleanProperties == null || cleanProperties.isEmpty()) {
            throw new IllegalArgumentException("cleanProperties == null || cleanProperties.isEmpty()");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint == null");
        }
        Map<String, String> newMap = null;
        newMap = debug ? new TreeMap<String, String>(cleanProperties) : cleanProperties;
        StringBuilder text = new StringBuilder();
        String submit_uuid = UUID.randomUUID().toString().replace("-", UNDERSCORE);
        text.append("<div id=\"ltiLaunchFormArea_");
        text.append(submit_uuid);
        text.append("\">\n");
        text.append("<form action=\"");
        text.append(endpoint);
        text.append("\" name=\"ltiLaunchForm\" id=\"ltiLaunchForm_" + submit_uuid + "\" method=\"post\" ");
        text.append(" encType=\"application/x-www-form-urlencoded\" accept-charset=\"utf-8\">\n");
        if (debug) {
            // empty if block
        }
        for (Map.Entry<String, String> entry : newMap.entrySet()) {
            Object key = entry.getKey();
            String string = entry.getValue();
            if (string == null) continue;
            key = BasicLTIUtil.htmlspecialchars((String)key);
            String string2 = BasicLTIUtil.htmlspecialchars(string);
            text.append("<input type=\"hidden\" name=\"");
            text.append((String)key);
            text.append("\" value=\"");
            text.append(string2);
            text.append("\"/>\n");
        }
        if (debug) {
            text.append("<input type=\"submit\" value=\"");
            text.append(BasicLTIUtil.htmlspecialchars(launchtext));
            text.append("\">\n");
            text.append(" <input type=\"Submit\" value=\"Show Launch Data\" onclick=\"document.getElementById('ltiLaunchDebug_");
            text.append(submit_uuid);
            text.append("').style.display = 'block';return false;\">\n");
        } else {
            text.append("<input type=\"submit\" style=\"display: none\" value=\"");
            text.append(BasicLTIUtil.htmlspecialchars(launchtext));
            text.append("\">\n");
        }
        if (extra != null && (button_html = extra.get(EXTRA_BUTTON_HTML)) != null) {
            text.append(button_html);
        }
        text.append("</form>\n");
        text.append("</div>\n");
        String error_timeout = null;
        String http_popup = null;
        if (extra != null) {
            error_timeout = extra.get(EXTRA_ERROR_TIMEOUT);
            http_popup = extra.get(EXTRA_HTTP_POPUP);
        }
        if (extra == null) {
            error_timeout = "Unable to send launch to remote URL: " + endpoint;
        }
        error_timeout = error_timeout + endpoint;
        text.append("<script type=\"text/javascript\">\n");
        text.append("var open_in_new_window = false;\n");
        if (!EXTRA_HTTP_POPUP_FALSE.equals(http_popup)) {
            text.append("if (window.top!=window.self) {\n");
            text.append("  var theform = document.getElementById('ltiLaunchForm_");
            text.append(submit_uuid);
            text.append("');\n");
            text.append("  if ( theform && theform.action ) {\n");
            text.append("    var formAction = theform.action;\n");
            text.append("    var ourUrl = window.location.href;\n");
            text.append("    if ( formAction.indexOf('http://') == 0 && ourUrl.indexOf('https://') == 0 ) {\n");
            text.append("      theform.target = '_blank';\n");
            text.append("      window.console && console.log('Launching http from https in new window!');\n");
            text.append("      open_in_new_window = true;\n");
            text.append("    }\n");
            text.append("  }\n");
            text.append("}\n");
        }
        text.append("</script>\n");
        if (debug) {
            String base_string;
            text.append("<pre id=\"ltiLaunchDebug_");
            text.append(submit_uuid);
            text.append("\" style=\"display: none\">\n");
            text.append("<b>BasicLTI Endpoint</b>\n");
            text.append(endpoint);
            text.append("\n\n");
            text.append("<b>BasicLTI Parameters:</b>\n");
            for (Map.Entry entry : newMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) continue;
                text.append(BasicLTIUtil.htmlspecialchars(key));
                text.append("=");
                text.append(BasicLTIUtil.htmlspecialchars(value));
                text.append("\n");
            }
            text.append("</pre>\n");
            if (extra != null && (base_string = extra.get("BaseString")) != null) {
                text.append("<!-- Base String\n");
                text.append(base_string.replaceAll("-->", "__>"));
                text.append("\n-->\n");
            }
        } else if (autosubmit) {
            text.append("<script language=\"javascript\"> \n");
            text.append("    document.getElementById('ltiLaunchFormArea_");
            text.append(submit_uuid);
            text.append("').style.display = \"none\";\n");
            text.append("    document.getElementById('ltiLaunchForm_");
            text.append(submit_uuid);
            text.append("').submit(); \n");
            text.append("if ( ! open_in_new_window ) {\n");
            text.append("   setTimeout(function() { alert(\"" + BasicLTIUtil.htmlspecialchars(error_timeout) + "\"); }, 4000);\n");
            text.append("}\n");
            text.append("</script> \n");
        }
        String htmltext = text.toString();
        return htmltext;
    }

    public static String getOAuthURL(String method, String url, String oauth_consumer_key, String oauth_secret) {
        return BasicLTIUtil.getOAuthURL(method, url, oauth_consumer_key, oauth_secret, null);
    }

    public static String getOAuthURL(String method, String url, String oauth_consumer_key, String oauth_secret, String signature) {
        OAuthMessage om = new OAuthMessage(method, url, null);
        om.addParameter("oauth_consumer_key", oauth_consumer_key);
        if (signature == null) {
            signature = "HMAC-SHA1";
        }
        om.addParameter("oauth_signature_method", signature);
        om.addParameter("oauth_version", "1.0");
        om.addParameter("oauth_timestamp", new Long(new Date().getTime() / 1000L).toString());
        om.addParameter("oauth_nonce", UUID.randomUUID().toString());
        OAuthConsumer oc = new OAuthConsumer(null, oauth_consumer_key, oauth_secret, null);
        try {
            OAuthSignatureMethod osm = OAuthSignatureMethod.newMethod(signature, new OAuthAccessor(oc));
            osm.sign(om);
            url = OAuth.addParameters(url, om.getParameters());
            return url;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HttpURLConnection sendOAuthURL(String method, String url, String oauth_consumer_key, String oauth_secret) {
        String oauthURL = BasicLTIUtil.getOAuthURL(method, url, oauth_consumer_key, oauth_secret);
        try {
            URL urlConn = new URL(oauthURL);
            HttpURLConnection connection = (HttpURLConnection)urlConn.openConnection();
            connection.setRequestMethod(method);
            if (!"GET".equals(method)) {
                connection.setDoOutput(true);
                OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
                out.write("42");
                out.close();
            }
            connection.connect();
            int responseCode = connection.getResponseCode();
            return connection;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static int getResponseCode(HttpURLConnection connection) {
        try {
            return connection.getResponseCode();
        }
        catch (Exception e) {
            return 500;
        }
    }

    public static String readHttpResponse(HttpURLConnection connection) {
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response.toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean parseDescriptor(Properties launch_info, Properties postProp, String descriptor) {
        Map<String, Object> tm = null;
        try {
            tm = XMLMap.getFullMap(descriptor.trim());
        }
        catch (Exception e) {
            log.warn("BasicLTIUtil exception parsing BasicLTI descriptor: {}", (Object)e.getMessage());
            return false;
        }
        if (tm == null) {
            log.warn("Unable to parse XML in parseDescriptor");
            return false;
        }
        String launch_url = BasicLTIUtil.toNull(XMLMap.getString(tm, "/basic_lti_link/launch_url"));
        String secure_launch_url = BasicLTIUtil.toNull(XMLMap.getString(tm, "/basic_lti_link/secure_launch_url"));
        if (launch_url == null && secure_launch_url == null) {
            return false;
        }
        BasicLTIUtil.setProperty(launch_info, "launch_url", launch_url);
        BasicLTIUtil.setProperty(launch_info, "secure_launch_url", secure_launch_url);
        BasicLTIUtil.setProperty(launch_info, "key", BasicLTIUtil.toNull(XMLMap.getString(tm, "/basic_lti_link/x-secure/launch_key")));
        BasicLTIUtil.setProperty(launch_info, "secret", BasicLTIUtil.toNull(XMLMap.getString(tm, "/basic_lti_link/x-secure/launch_secret")));
        List<Map<String, Object>> theList = XMLMap.getList(tm, "/basic_lti_link/custom/parameter");
        for (Map<String, Object> setting : theList) {
            log.debug("Setting={}", setting);
            String key = XMLMap.getString(setting, "/!key");
            String value = XMLMap.getString(setting, "/");
            if (key == null || value == null) continue;
            key = "custom_" + BasicLTIUtil.mapKeyName(key);
            log.debug("key={} val={}", (Object)key, (Object)value);
            postProp.setProperty(key, value);
        }
        return true;
    }

    public static boolean parseDescriptor(Map<String, String> launch_info, Map<String, String> postProp, String descriptor) {
        Map<String, Object> tm = null;
        try {
            tm = XMLMap.getFullMap(descriptor.trim());
        }
        catch (Exception e) {
            log.warn("BasicLTIUtil exception parsing BasicLTI descriptor: {}", (Object)e.getMessage());
            return false;
        }
        if (tm == null) {
            log.warn("Unable to parse XML in parseDescriptor");
            return false;
        }
        String launch_url = BasicLTIUtil.toNull(XMLMap.getString(tm, "/basic_lti_link/launch_url"));
        String secure_launch_url = BasicLTIUtil.toNull(XMLMap.getString(tm, "/basic_lti_link/secure_launch_url"));
        if (launch_url == null && secure_launch_url == null) {
            return false;
        }
        BasicLTIUtil.setProperty(launch_info, "launch_url", launch_url);
        BasicLTIUtil.setProperty(launch_info, "secure_launch_url", secure_launch_url);
        BasicLTIUtil.setProperty(launch_info, "key", BasicLTIUtil.toNull(XMLMap.getString(tm, "/basic_lti_link/x-secure/launch_key")));
        BasicLTIUtil.setProperty(launch_info, "secret", BasicLTIUtil.toNull(XMLMap.getString(tm, "/basic_lti_link/x-secure/launch_secret")));
        List<Map<String, Object>> theList = XMLMap.getList(tm, "/basic_lti_link/custom/parameter");
        for (Map<String, Object> setting : theList) {
            log.debug("Setting={}", setting);
            String key = XMLMap.getString(setting, "/!key");
            String value = XMLMap.getString(setting, "/");
            if (key == null || value == null) continue;
            key = "custom_" + BasicLTIUtil.mapKeyName(key);
            log.debug("key={} val={}", (Object)key, (Object)value);
            postProp.put(key, value);
        }
        return true;
    }

    public static String prepareForExport(String descriptor) {
        Map<String, Object> tm = null;
        try {
            tm = XMLMap.getFullMap(descriptor.trim());
        }
        catch (Exception e) {
            log.warn("BasicLTIUtil exception parsing BasicLTI descriptor {}", (Object)e.getMessage());
            return null;
        }
        if (tm == null) {
            log.warn("Unable to parse XML in prepareForExport");
            return null;
        }
        XMLMap.removeSubMap(tm, "/basic_lti_link/x-secure");
        String retval = XMLMap.getXML(tm, true);
        return retval;
    }

    public static String mapKeyName(String keyname) {
        StringBuffer sb = new StringBuffer();
        if (keyname == null) {
            return null;
        }
        if ((keyname = keyname.trim()).length() < 1) {
            return null;
        }
        for (int i = 0; i < keyname.length(); ++i) {
            Character ch = Character.valueOf(Character.toLowerCase(keyname.charAt(i)));
            if (Character.isLetter(ch.charValue()) || Character.isDigit(ch.charValue())) {
                sb.append(ch);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public static String toNull(String str) {
        if (str == null) {
            return null;
        }
        if (str.trim().length() < 1) {
            return null;
        }
        return str;
    }

    public static void setProperty(Map<String, String> map, String key, String value) {
        if (value != null && !"".equals(value)) {
            map.put(key, value);
        }
    }

    public static void setProperty(Properties props, String key, String value) {
        if (value == null) {
            return;
        }
        if (value.trim().length() < 1) {
            return;
        }
        props.setProperty(key, value);
    }

    public static String htmlspecialchars(String input) {
        if (input == null) {
            return null;
        }
        String retval = input.replace("&", "&amp;");
        retval = retval.replace("\"", "&quot;");
        retval = retval.replace("<", "&lt;");
        retval = retval.replace(">", "&gt;");
        retval = retval.replace("=", "&#61;");
        return retval;
    }

    public static String mergeCSV(String old_id_history, String new_id_history, String old_resource_link_id) {
        if (BasicLTIUtil.isBlank(old_id_history)) {
            old_id_history = "";
        }
        if (BasicLTIUtil.isBlank(new_id_history)) {
            new_id_history = "";
        }
        List<String> old_id_list = Arrays.asList(old_id_history.split(","));
        List<String> new_id_list = Arrays.asList(new_id_history.split(","));
        ArrayList<String> new_list = new ArrayList<String>();
        for (String old_id : old_id_list) {
            if (BasicLTIUtil.isBlank(old_id) || new_list.contains(old_id)) continue;
            new_list.add(old_id);
        }
        for (String new_id : new_id_list) {
            if (BasicLTIUtil.isBlank(new_id) || new_list.contains(new_id)) continue;
            new_list.add(new_id);
        }
        if (BasicLTIUtil.isNotBlank(old_resource_link_id) && !new_list.contains(old_resource_link_id)) {
            new_list.add(old_resource_link_id);
        }
        String id_history = String.join((CharSequence)",", new_list);
        return id_history;
    }

    public static String getRealPath(String servletUrl, String extUrl) {
        Pattern pat = Pattern.compile("^https??://[^/]*");
        Matcher m = pat.matcher(extUrl);
        if (m.find()) {
            extUrl = m.group(0);
        }
        String retval = pat.matcher(servletUrl).replaceFirst(extUrl);
        return retval;
    }

    public static String getRealPath(HttpServletRequest request, String extUrl) {
        String URLstr = request.getRequestURL().toString();
        String retval = BasicLTIUtil.getRealPath(URLstr, extUrl);
        return retval;
    }

    public static Map<String, String> convertToMap(Properties properties) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(properties);
        return map;
    }

    public static Properties convertToProperties(Map<String, String> map) {
        Properties properties = new Properties();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                properties.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return properties;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !BasicLTIUtil.isBlank(str);
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static String getISO8601() {
        return BasicLTIUtil.getISO8601(null);
    }

    public static String getISO8601(Date date) {
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat isoFormat = new SimpleDateFormat(ISO_8601_FORMAT);
        isoFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timestamp = isoFormat.format(date);
        timestamp = timestamp.replace("GMT", "Z");
        return timestamp;
    }

    public static JSONObject parseJSONObject(String str) {
        JSONObject content_json = null;
        if (str != null) {
            content_json = (JSONObject)JSONValue.parse((String)str);
        }
        if (content_json == null) {
            content_json = new JSONObject();
        }
        if (!(content_json instanceof JSONObject)) {
            content_json = new JSONObject();
        }
        return content_json;
    }

    public static JSONArray forceArray(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONArray) {
            return (JSONArray)obj;
        }
        JSONArray retval = new JSONArray();
        retval.add(obj);
        return retval;
    }

    public static JSONArray getArray(JSONObject obj, String key) {
        if (obj == null) {
            return null;
        }
        Object o = obj.get((Object)key);
        if (o == null) {
            return null;
        }
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        if (o instanceof JSONObject) {
            JSONArray retval = new JSONArray();
            retval.add(o);
            return retval;
        }
        String className = o.getClass().getName();
        if (className.startsWith("java.lang")) {
            JSONArray retval = new JSONArray();
            retval.add(o);
            return retval;
        }
        return null;
    }

    public static JSONObject getObject(JSONObject obj, String key) {
        if (obj == null) {
            return null;
        }
        if (key == null) {
            return null;
        }
        Object o = obj.get((Object)key);
        if (o == null) {
            return null;
        }
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        return null;
    }

    public static String getString(JSONObject obj, String key) {
        if (obj == null) {
            return null;
        }
        if (key == null) {
            return null;
        }
        Object o = obj.get((Object)key);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static Long getLong(JSONObject obj, String key) {
        if (obj == null) {
            return null;
        }
        if (key == null) {
            return null;
        }
        Object o = obj.get((Object)key);
        if (o instanceof Number) {
            return new Long(((Number)o).longValue());
        }
        if (o instanceof String) {
            if (((String)o).length() < 1) {
                return new Long(-1L);
            }
            try {
                return new Long((String)o);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static Double getDouble(JSONObject obj, String key) {
        if (obj == null) {
            return null;
        }
        if (key == null) {
            return null;
        }
        Object o = obj.get((Object)key);
        if (o instanceof Number) {
            return new Double(((Number)o).longValue());
        }
        if (o instanceof String) {
            if (((String)o).length() < 1) {
                return new Double(-1.0);
            }
            try {
                return new Double((String)o);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

