/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.lti13;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Map;
import java.util.TreeMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tsugi.lti13.LTI13Util;

public class LTI13KeySetUtil {
    private static final Logger log = LoggerFactory.getLogger(LTI13KeySetUtil.class);

    public static String getPublicKID(Key key) {
        String publicEncoded = LTI13Util.getPublicEncoded(key);
        return new Integer(publicEncoded.hashCode()).toString();
    }

    public static String getKeySetJSON(Map<String, RSAPublicKey> keys) throws NoSuchAlgorithmException {
        JSONArray jar = new JSONArray();
        for (Map.Entry<String, RSAPublicKey> entry : keys.entrySet()) {
            RSAPublicKey key = entry.getValue();
            RSAKey rsaKey = new RSAKey.Builder(key).algorithm((Algorithm)JWSAlgorithm.RS256).build();
            String keyStr = rsaKey.toJSONString();
            JSONObject kobj = (JSONObject)JSONValue.parse((String)keyStr);
            kobj.put((Object)"kid", (Object)entry.getKey());
            kobj.put((Object)"use", (Object)"sig");
            jar.add((Object)kobj);
        }
        JSONObject keyset = new JSONObject();
        keyset.put((Object)"keys", (Object)jar);
        String keySetJSON = keyset.toString();
        return keySetJSON;
    }

    public static String getKeySetJSON(String kid, RSAPublicKey key) throws NoSuchAlgorithmException {
        TreeMap<String, RSAPublicKey> keys = new TreeMap<String, RSAPublicKey>();
        keys.put(kid, key);
        return LTI13KeySetUtil.getKeySetJSON(keys);
    }

    public static String getKeySetJSON(RSAPublicKey key) throws NoSuchAlgorithmException {
        TreeMap<String, RSAPublicKey> keys = new TreeMap<String, RSAPublicKey>();
        String kid = LTI13KeySetUtil.getPublicKID(key);
        keys.put(kid, key);
        return LTI13KeySetUtil.getKeySetJSON(keys);
    }

    public static RSAPublicKey getKeyFromKeySet(String kid, String url) throws ParseException, JOSEException, MalformedURLException, IOException {
        JWKSet localKeys = JWKSet.load((URL)new URL(url));
        RSAKey nimbusPublic = (RSAKey)localKeys.getKeyByKeyId(kid);
        RSAPublicKey publicKey = nimbusPublic.toRSAPublicKey();
        return publicKey;
    }

    public static RSAPublicKey getKeyFromKeySetString(String kid, String json) throws ParseException, JOSEException {
        JWKSet localKeys = JWKSet.parse((String)json);
        RSAKey nimbusPublic = (RSAKey)localKeys.getKeyByKeyId(kid);
        RSAPublicKey publicKey = nimbusPublic.toRSAPublicKey();
        return publicKey;
    }
}

