/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.lti13;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tsugi.lti13.LTI13Util;

public class LTI13Servlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(LTI13Servlet.class);
    private static final long serialVersionUID = 1L;
    private static final String APPLICATION_JSON = "application/json";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getRequestURI();
        String[] parts = uri.split("/");
        if (parts.length > 2 && "keys".equals(parts[3])) {
            PrintWriter out = null;
            Map<String, String> retval = null;
            try {
                out = response.getWriter();
                retval = LTI13Util.generateKeys();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return;
            }
            String jsonText = JSONValue.toJSONString(retval);
            response.setContentType(APPLICATION_JSON);
            try {
                out.println(jsonText);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return;
        }
        response.setContentType("text/html");
        try {
            PrintWriter out = response.getWriter();
            out.println("Yada456");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.error("Yada");
    }
}

