/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.util.List;
import java.util.Map;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.ListSheet;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.StringUtil;

public class ListMapSheet
extends ListSheet<Map<String, ?>> {
    public ListMapSheet() {
    }

    public ListMapSheet(String name) {
        super(name);
    }

    public ListMapSheet(String name, Sheet.Column ... columns) {
        super(name, columns);
    }

    public ListMapSheet(String name, WaterMark waterMark, Sheet.Column ... columns) {
        super(name, waterMark, columns);
    }

    public ListMapSheet(List<Map<String, ?>> data) {
        this((String)null, data);
    }

    public ListMapSheet(String name, List<Map<String, ?>> data) {
        super(name);
        this.setData(data);
    }

    public ListMapSheet(List<Map<String, ?>> data, Sheet.Column ... columns) {
        this((String)null, data, columns);
    }

    public ListMapSheet(String name, List<Map<String, ?>> data, Sheet.Column ... columns) {
        this(name, data, (WaterMark)null, columns);
    }

    public ListMapSheet(List<Map<String, ?>> data, WaterMark waterMark, Sheet.Column ... columns) {
        this((String)null, data, waterMark, columns);
    }

    public ListMapSheet(String name, List<Map<String, ?>> data, WaterMark waterMark, Sheet.Column ... columns) {
        super(name, waterMark, columns);
        this.setData(data);
    }

    @Override
    protected void resetBlockData() {
        if (!this.eof && this.size() < this.getRowBlockSize()) {
            this.append();
        }
        int end = this.getEndIndex();
        int len = this.columns.length;
        while (this.start < end) {
            Row row = this.rowBlock.next();
            row.index = this.rows;
            Cell[] cells = row.realloc(len);
            for (int i = 0; i < len; ++i) {
                Sheet.Column hc = this.columns[i];
                Object e = ((Map)this.data.get(this.start)).get(hc.key);
                Cell cell = cells[i];
                cell.clear();
                this.setCellValueAndStyle(cell, e, hc);
            }
            ++this.rows;
            ++this.start;
        }
    }

    @Override
    public Sheet.Column[] getHeaderColumns() {
        if (this.headerReady) {
            return this.columns;
        }
        Map first = (Map)this.getFirst();
        if (first == null) {
            if (this.columns == null) {
                this.columns = new Sheet.Column[0];
            }
        } else if (!this.hasHeaderColumns()) {
            int size = first.size();
            int i = 0;
            this.columns = new Sheet.Column[size];
            for (Map.Entry entry : first.entrySet()) {
                if (StringUtil.isEmpty((String)entry.getKey())) continue;
                Object value = entry.getValue();
                this.columns[i++] = new Sheet.Column((String)entry.getKey(), (String)entry.getKey(), value != null ? value.getClass() : String.class);
            }
        } else {
            for (int i = 0; i < this.columns.length; ++i) {
                Sheet.Column hc = this.columns[i];
                if (StringUtil.isEmpty(hc.key)) {
                    throw new ExcelWriteException(this.getClass() + " must specify the 'key' name.");
                }
                if (hc.getClazz() != null) continue;
                hc.setClazz(first.get(hc.key).getClass());
            }
        }
        this.checkColumnLimit();
        for (Sheet.Column hc : this.columns) {
            hc.styles = this.workbook.getStyles();
        }
        this.headerReady = this.columns.length > 0;
        return this.columns;
    }
}

